<cfoutput>
  <b>I-Tech Library</b>
  <br><br>
  Allows the user to change re-organize infrastructure research levels.
  <br>
  This project has a 72 hour activation timer, in addition to a high cost.
</cfoutput>

<cfset output = "">

<cfif len(getprojectuser.activate) LTE 0 OR parameterexists(Process)>
  <!--- Post Check for distribution --->
  <cfif parameterexists(form.Distribute)>

    <!--- Total Infra submitted --->
    <cfset Res_Dis = 0>

    <!--- Housing to Mining Infrastructure Research --->
    <cfloop index="I" from="1" to="5">
      <cfif isdefined("form.r_#I#") and len(ReReplace(evaluate("form.r_#I#"),"[^0-9]","","ALL")) gt 0>
        <cfset "Res_#I#" = ReReplace(evaluate("form.r_#I#"),"[^0-9]","","ALL")>
        <cfset Res_Dis = Res_Dis + evaluate("Res_#I#")>
      <cfelse>
        <cfset "Res_#I#" = 0>
      </cfif>
    </cfloop>

    <!--- Probably attempted injection or negative values --->
    <cfif Res_Dis LT 1>
      <cfset Output = "You didn't select any infra to Redistribute!">
    <!--- Probably higher values attempted --->
    <cfelseif Res_Dis GT 0 and Res_Dis GT InfraFetch.R_Total>
      <cfset Output = "You used more infrastructure than you have to allocate!">
    <cfelseif Res_Dis LT InfraFetch.R_Total>
      <cfset Output = "You have more infra to apply!">
    <!--- Normal Process --->
    <cfelse>

      <cfset Output = "Infra Research Redistributed!">
      <cfset Display = 2>

    <!--- Update Database --->
    <cfquery datasource="#DS#">
      UPDATE [user]
      SET r_1 = #Res_1#, r_2 = #Res_2#, r_3 = #Res_3#, r_4 = #Res_4#, r_5 = #Res_5#
      WHERE id=#session.userid#;

      UPDATE project_user
      SET credit = 0, turn = 0, activate = #createodbcdatetime(dateadd("h",+72,now()))#, finishflag = 0
      WHERE userid=#session.userid# AND project=4;

      INSERT INTO event (userid, datetime, name)
      VALUES (#session.userid#, #createodbcdatetime(now())#,'<b>Researcher: </b>Infrastructure levels has been redistributed !');
    </cfquery>

      <!--- Update Application Layer --->
      <cflock name="#APPLICATION.applicationName#_infrastructure_#session.userid#" type="Exclusive" timeout="20">
        <cfscript>
          "application.research_infrastructure_#session.userid#_1" = Res_1;
          "application.research_infrastructure_#session.userid#_2" = Res_2;
          "application.research_infrastructure_#session.userid#_3" = Res_3;
          "application.research_infrastructure_#session.userid#_4" = Res_4;
          "application.research_infrastructure_#session.userid#_5" = Res_5;
        </cfscript>
      </cflock>

      <!--- Base SQL Query for data neeeded --->
      <cfquery datasource="#DS#" name="InfraFetch">
        SELECT SUM(r_1 + r_2 + r_3 + r_4 + r_5) AS R_Total, r_1, r_2, r_3, r_4 ,r_5, reslevel
        FROM [user]
        WHERE id=#session.userid#
        GROUP BY r_1, r_2, r_3, r_4, r_5, reslevel;
      </cfquery>

      <cfquery  datasource="#DS#" name="getcolall">
        SELECT id,housing
        FROM col
        WHERE userid=#session.userid#
      </cfquery>

      <cfloop query="getcolall">
        <cfset maxpop= (housing +  (housing * (evaluate("application.research_infrastructure_#session.userid#_1") * 0.10)))* 10 >
        <cfset maxpop = fix(maxpop)>

          <cfquery datasource="#DS#">
            UPDATE col
            SET pop = #maxpop#
            WHERE id = #id#
          </cfquery>
      </cfloop>

    </cfif>
  </cfif>

  <!--- User Output #1 --->
  <cfoutput>
    <form method="POST">
      <div style="width: 100%; text-align: center;">
        <br><span style="color: orange; font-size: 1.2em; text-align: center;">#Output#</span><br><br>
        <table cellspacing=0 cellpadding=0 border=0 style="width: auto; display: inline-block;" class=table_back>
          <tr><td>
            <table cellspacing=1 cellpadding=1 border=0 style="width: auto;">

            <cfif parameterexists(Display) AND Display is 2>
              <tr class=table_row0 align=center><Td style="padding: 0 0.5em; text-align: center;" colspan="3">Infra Distribution</td></tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Housing</td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_1,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Commercial</td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_2,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Industry</td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_3,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Agriculture</td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_4,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Mining</td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_5,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>
            <cfelse>
              <tr class=table_row0 align=center><Td style="padding: 0 0.5em; text-align: center;" colspan="3">Infra Redistribution</td></tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Housing</td>
                <Td style="text-align: center; padding: 0 0.5em;"><input type="text" name="r_1" maxlength="3" value="#trim(numberformat(InfraFetch.r_1,'_,_,_,_,_,_,_,_,_,_'))#" size="3"></td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_1,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Commercial</td>
                <Td style="text-align: center; padding: 0 0.5em;"><input type="text" name="r_2" maxlength="3" value="#trim(numberformat(InfraFetch.r_2,'_,_,_,_,_,_,_,_,_,_'))#" size="3"></td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_2,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Industry</td>
                <Td style="text-align: center; padding: 0 0.5em;"><input type="text" name="r_3" maxlength="3" value="#trim(numberformat(InfraFetch.r_3,'_,_,_,_,_,_,_,_,_,_'))#" size="3"></td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_3,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Agriculture</td>
                <Td style="text-align: center; padding: 0 0.5em;"><input type="text" name="r_4" maxlength="3" value="#trim(numberformat(InfraFetch.r_4,'_,_,_,_,_,_,_,_,_,_'))#" size="3"></td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_4,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="text-align: left; padding: 0 0.5em;">Mining</td>
                <Td style="text-align: center; padding: 0 0.5em;"><input type="text" name="r_5" maxlength="3" value="#trim(numberformat(InfraFetch.r_5,'_,_,_,_,_,_,_,_,_,_'))#" size="3"></td>
                <Td style="text-align: center; padding: 0 0.5em;">#trim(numberformat(InfraFetch.r_5,'_,_,_,_,_,_,_,_,_,_'))#</td>
              </tr>

              <tr class=table_row1 valign=top align=center>
                <td style="padding: 0 0.5em;" colspan="2"><input type="Submit" value="  Distribute  " name="Distribute"></td><td style="padding: 0 0.5em;"><input type="Submit" value="  Cancel  " name="Cancel"></td>
              </tr>
            </cfif>
            </table>
          </td></tr>
        </table>
      </div>
    </form>
  </cfoutput>
</cfif>
