<cfsetting enablecfoutputonly="yes">
<!--- requires temp_userid --->
<!--- File updated on: 01/28/2015 --->

<cfparam name="temp_server" default=0>
<cfparam name="temp_race" default=1>
<cfparam name="temp_day_paid" default=0>

<cfscript>

	/* If Statements based upon race => server for varried settings across each server
	 *	tempFoodIns   => Starting food value
	 *	tempOreIns    => Starting ore value
	 *	tempCGIns     => Starting Goods value
	 *	tempRMIns     => Starting Raw Mats value
	 *	tempGood_1    => Starting Terran Metal value
	 *	tempGood_2    => Starting Red Crystal value
	 *	tempGood_3    => Starting White Crystal value
	 *	tempGood_4    => Starting Rutile value
	 *	tempGood_5    => Starting Composite value
	 *	tempGood_6    => Starting Strafez value
	 *	tempCol_Type  => Starting Colony Class (Class being type of planet I.E:- Barren, or Balanced, or Etc.)
	 *	tempCol_Min   => Starting Colony Mineral (Terran metal through Strafez)
	 *	tempCol_Land  => Starting Colony Land
	 *	tempCol_Loy   => Starting Colony Loyalty
	 *	tempCol_Class => Starting Colony Type (Type being the planet type I.E:- E.xxxx (Explored colony), or H.xxxx (homeworld), or Etc.)
	 *	tempCol_Pop   => Starting Colony Population (Population on the colony itself)
	 *	tempCol_Ore   => Starting Colony Ore (Ore which can be mined off the colony)
	 *  selfBTC       => Self-Use BTC for fresh accounts on turnbased
	 *  selfBTCID     => ID of Self-Use BTC
	 *	tempCol_Housing-Mining => Starting Infra on the planet (Example 1 housing for 10 population)
	 */

	tempL = 1;

	if (temp_server is 2) //If server is slow then we give 25 Self-Use BTC
	{
		selfBTC   = " 25,10,";
		selfBTCID = "g71,g72,";

	}
	else if (temp_server is 0) //If server is Normal then we give 20 Self-Use BTC
	{
		selfBTC   = " 20,10,";
		selfBTCID = "g71,g72,";
	}
	else if (temp_server is 1) //If server is Fast then we give 5 Self-Use BTC
	{
		selfBTC   = " 10,5,";
		selfBTCID = "g71,g72,";
	}
	else if (temp_server is 3) //If server is Ultra then we give 2 Self-Use BTC
	{
		selfBTC   = " 5,5,";
		selfBTCID = "g71,g72,";
	}
	else //Else we don't give any
	{
		selfBTC   = "5,";
		selfBTCID = "g72,";
	}

    if (temp_race is 1) //Terran Race
	{
		tempCol_Type  = 8; //Balanced
		tempCol_Class = 1; //Homeworld
		tempCol_Min   = 1; //Terran Metal
		tempCol_Industry = 0;

		if (temp_server is 0) //Normal Server
		{
			tempcredit   = RandRange(1000000,2500000);
			tempFoodIns  = RandRange(250000,750000);
			tempOreIns   = RandRange(3000,5000);
			tempRMIns    = RandRange(50000,100000);
			tempCGIns    = RandRange(250000,750000);
			tempCol_Land = 3000;
			tempCol_Ore  = 2500;
			tempCol_Loy  = RandRange(3000,5000);
			tempCol_Pop  = 1000;
			tempCol_Housing = 100;
			tempCol_Comm    = 400;
			tempCol_Agri    = 400;
			tempCol_Mining  = 45;


			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(50000,75000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 1) // Fast Server
		{
			tempcredit   = RandRange(600000,1150000);
			tempFoodIns  = RandRange(35000,60000);
			tempOreIns   = RandRange(1000,2500);
			tempRMIns    = RandRange(25000,35000);
			tempCGIns    = RandRange(75000,120000);
			tempCol_Land = 2500;
			tempCol_Ore  = 2000;
			tempCol_Loy  = RandRange(2000,5000);
			tempCol_Pop  = 700;
			tempCol_Housing = 70;
			tempCol_Comm    = 250;
			tempCol_Agri    = 300;
			tempCol_Mining  = 30;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(37500,50000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 2) // Slow Server
		{
			tempcredit   = RandRange(1500000,3500000);
			tempFoodIns  = RandRange(500000,1250000);
			tempOreIns   = RandRange(5000,7000);
			tempRMIns    = RandRange(75000,150000);
			tempCGIns    = RandRange(500000,1000000);
			tempCol_Land = 3500;
			tempCol_Ore  = 3000;
			tempCol_Loy  = RandRange(3500,5000);
			tempCol_Pop  = 1000;
			tempCol_Housing = 100;
			tempCol_Comm    = 400;
			tempCol_Agri    = 400;
			tempCol_Mining  = 45;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(50000,85000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 3) //Ultra Server
		{
			tempcredit   = RandRange(500000,1000000);
			tempFoodIns  = RandRange(35000,50000);
			tempOreIns   = RandRange(750,1750);
			tempRMIns    = RandRange(15000,25000);
			tempCGIns    = RandRange(50000,100000);
			tempCol_Land = 2250;
			tempCol_Ore  = 1750;
			tempCol_Loy  = RandRange(1500,4500);
			tempCol_Pop  = 500;
			tempCol_Housing = 50;
			tempCol_Comm    = 200;
			tempCol_Agri    = 200;
			tempCol_Mining  = 20;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(25000,40000);
				tempL = tempL + 1;
			}
		}
		else //RT, DM, & Not found
		{
			tempcredit   = RandRange(350000,750000);
			tempFoodIns  = RandRange(25000,50000);
			tempOreIns   = RandRange(500,1500);
			tempRMIns    = RandRange(10000,15000);
			tempCGIns    = RandRange(30000,80000);
			tempCol_Land = 2000;
			tempCol_Ore  = 1500;
			tempCol_Loy  = RandRange(1000,4500);
			tempCol_Pop  = 255;
			tempCol_Housing = 40;
			tempCol_Comm    = 100;
			tempCol_Agri    = 100;
			tempCol_Mining  = 15;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(20000,30000);
				tempL = tempL + 1;
			}
		}
	}
	else if (temp_race is 2) //Marauder Race
	{
		tempCol_Type  = 25; //U.Fertile
		tempCol_Class = 3; //Baseworld
		tempCol_Min   = 3; //White Crystal
		tempCGIns     = 10000;
		tempCol_Industry = 0;
		tempCol_Comm     = 0;
		tempCol_Mining   = 0;
		tempCol_Ore  = 0;

		if (temp_server is 0) //Normal Server
		{
			tempcredit   = RandRange(3000000,5000000);
			tempFoodIns  = RandRange(350000,750000);
			tempOreIns   = RandRange(7500,17000);
			tempRMIns    = RandRange(25000,50000);
			tempCol_Land = 3000;
			tempCol_Loy  = RandRange(2000,4000);
			tempCol_Pop  = 600;
			tempCol_Housing = 60;
			tempCol_Agri    = 500;


			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(15000,35000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 1) // Fast Server
		{
			tempcredit   = RandRange(2000000,4500000);
			tempFoodIns  = RandRange(100000,250000);
			tempOreIns   = RandRange(6500,15000);
			tempRMIns    = RandRange(15000,25000);
			tempCol_Land = 2750;
			tempCol_Loy  = RandRange(1500,3500);
			tempCol_Pop  = 500;
			tempCol_Housing = 50;
			tempCol_Agri    = 400;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(10000,25000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 2) // Slow Server
		{
			tempcredit   = RandRange(3500000,7000000);
			tempFoodIns  = RandRange(550000,1000000);
			tempOreIns   = RandRange(10000,18500);
			tempRMIns    = RandRange(35000,75000);
			tempCol_Land = 3500;
			tempCol_Loy  = RandRange(2500,4500);
			tempCol_Pop  = 600;
			tempCol_Housing = 60;
			tempCol_Agri    = 500;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(20000,50000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 3) //Ultra Server
		{
			tempcredit   = RandRange(1500000,2500000);
			tempFoodIns  = RandRange(70000,100000);
			tempOreIns   = RandRange(5000,12000);
			tempRMIns    = RandRange(10000,20000);
			tempCol_Land = 2250;
			tempCol_Loy  = RandRange(1000,3000);
			tempCol_Pop  = 500;
			tempCol_Housing = 50;
			tempCol_Agri    = 400;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(8000,15000);
				tempL = tempL + 1;
			}
		}
		else //RT, DM, & Not found
		{
			tempcredit   = RandRange(1000000,1500000);
			tempFoodIns  = RandRange(50000,100000);
			tempOreIns   = RandRange(3000,8000);
			tempRMIns    = RandRange(10000,15000);
			tempCol_Land = 3000;
			tempCol_Loy  = RandRange(500,2500);
			tempCol_Pop  = 400;
			tempCol_Housing = 40;
			tempCol_Agri    = 250;
			tempCol_Mining   = 10;
			tempCol_Ore  = 2000;
			tempCol_Type  = 4; //Forest

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(5000,10000);
				tempL = tempL + 1;
			}
		}
	}
	else if (temp_race is 3) //Guardian Race
	{
		tempCol_Type  = 8; //Balanced
		tempCol_Class = 3; //Baseworld
		tempCol_Min   = 2; //Red Crystal
		tempFoodIns   = 0;
		tempRMIns     = 0;
		tempCol_Comm     = 0;
		tempCol_Industry = 0;
		tempCol_Agri     = 0;
		tempCol_Loy = 2500;

		if (temp_server is 0) //Normal Server
		{
			tempcredit   = RandRange(3500000,5500000);
			tempOreIns   = RandRange(1200,1500);
			tempCGIns    = RandRange(250000,1000000);
			tempCol_Land = 2250;
			tempCol_Ore  = 1750;
			tempCol_Pop  = 1000;
			tempCol_Housing = 150;
			tempCol_Mining  = 15;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(40000,50000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 1) // Fast Server
		{
			tempcredit   = RandRange(2000000,5000000);
			tempOreIns   = RandRange(600,1000);
			tempCGIns    = RandRange(100000,250000);
			tempCol_Land = 2000;
			tempCol_Ore  = 1600;
			tempCol_Pop  = 750;
			tempCol_Housing = 100;
			tempCol_Mining  = 12;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(30000,35000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 2) // Slow Server
		{
			tempcredit   = RandRange(4000000,7000000);
			tempOreIns   = RandRange(1200,1700);
			tempCGIns    = RandRange(500000,1250000);
			tempCol_Land = 2500;
			tempCol_Ore  = 2000;
			tempCol_Pop  = 1000;
			tempCol_Housing = 150;
			tempCol_Mining  = 15;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(45000,50000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 3) //Ultra Server
		{
			tempcredit   = RandRange(1500000,3000000);
			tempOreIns   = RandRange(500,800);
			tempCGIns    = RandRange(75000,150000);
			tempCol_Land = 1750;
			tempCol_Ore  = 1400;
			tempCol_Pop  = 750;
			tempCol_Housing = 100;
			tempCol_Mining  = 7;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(25000,45000);
				tempL = tempL + 1;
			}
		}
		else //RT, DM, & Not found
		{
			tempcredit   = RandRange(1000000,2000000);
			tempOreIns   = RandRange(300,500);
			tempCGIns    = RandRange(50000,150000);
			tempCol_Land = 1500;
			tempCol_Ore  = 1200;
			tempCol_Pop  = 500;
			tempCol_Housing = 50;
			tempCol_Mining  = 5;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(15000,30000);
				tempL = tempL + 1;
			}
		}
	}
	else if (temp_race is 4) //Collective Race
	{
		tempCol_Type  = 40; //Similare C.1
		tempCol_Class = 3; //Baseworld
		tempCol_Min   = 5; //Composite
		tempRMIns     = 10000;
		tempCol_Comm     = 0;
		tempCol_Industry = 0;


		if (temp_server is 0) //Normal Server
		{
			tempcredit   = RandRange(2500000,4000000);
			tempFoodIns  = RandRange(100000,500000);
			tempOreIns   = RandRange(5000,12000);
			tempCGIns    = RandRange(70000,125000);
			tempCol_Land = 4000;
			tempCol_Ore  = 3500;
			tempCol_Loy  = RandRange(2000,4000);
			tempCol_Pop  = 2000;
			tempCol_Housing = 100;
			tempCol_Agri    = 600;
			tempCol_Mining  = 30;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(55000,90000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 1) // Fast Server
		{
			tempcredit   = RandRange(1500000,2500000);
			tempFoodIns  = RandRange(45000,90000);
			tempOreIns   = RandRange(3500,8000);
			tempCGIns    = RandRange(30000,45000);
			tempCol_Land = 3750;
			tempCol_Ore  = 3000;
			tempCol_Loy  = RandRange(1500,3500);
			tempCol_Pop  = 2000;
			tempCol_Housing = 100;
			tempCol_Agri    = 400;
			tempCol_Mining  = 20;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(40000,80000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 2) // Slow Server
		{
			tempcredit   = RandRange(3000000,5000000);
			tempFoodIns  = RandRange(450000,1000000);
			tempOreIns   = RandRange(8000,15000);
			tempCGIns    = RandRange(100000,150000);
			tempCol_Land = 4500;
			tempCol_Ore  = 4000;
			tempCol_Loy  = RandRange(2500,4500);
			tempCol_Pop  = 2000;
			tempCol_Housing = 100;
			tempCol_Agri    = 600;
			tempCol_Mining  = 30;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(60000,100000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 3) //Ultra Server
		{
			tempcredit   = RandRange(1000000,1750000);
			tempFoodIns  = RandRange(45000,75000);
			tempOreIns   = RandRange(2500,7000);
			tempCGIns    = RandRange(25000,30000);
			tempCol_Land = 3350;
			tempCol_Ore  = 2500;
			tempCol_Loy  = RandRange(1000,3500);
			tempCol_Pop  = 2000;
			tempCol_Housing = 100;
			tempCol_Agri    = 300;
			tempCol_Mining  = 15;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(35000,75000);
				tempL = tempL + 1;
			}
		}
		else //RT, DM, & Not found
		{
			tempcredit   = RandRange(750000,1000000);
			tempFoodIns  = RandRange(30000,50000);
			tempOreIns   = RandRange(1500,5000);
			tempCGIns    = RandRange(10000,15000);
			tempCol_Land = 3000;
			tempCol_Ore  = 2000;
			tempCol_Loy  = RandRange(500,3000);
			tempCol_Pop  = 130;
			tempCol_Housing = 30;
			tempCol_Agri    = 100;
			tempCol_Mining  = 10;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(30000,60000);
				tempL = tempL + 1;
			}
		}
	}
	else if (temp_race is 5) //Viral Race
	{
		tempCol_Type  = 50; //Tainted C.1
		tempCol_Class = 3; //Baseworld
		tempCol_Min   = 6; //Strafez Organism
		tempRMIns     = 10000;
		tempCol_Industry = 0;

		if (temp_server is 0) //Normal Server
		{
			tempcredit   = RandRange(750000,1250000);
			tempFoodIns  = RandRange(50000,150000);
			tempOreIns   = RandRange(750,1250);
			tempCGIns    = RandRange(50000,100000);
			tempCol_Land = 2250;
			tempCol_Ore  = 1750;
			tempCol_Loy  = RandRange(1500,3000);
			tempCol_Pop  = 300;
			tempCol_Housing = 50;
			tempCol_Comm    = 75;
			tempCol_Agri    = 75;
			tempCol_Mining  = 15;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(30000,50000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 1) // Fast Server
		{
			tempcredit   = RandRange(500000,1000000);
			tempFoodIns  = RandRange(30000,45000);
			tempOreIns   = RandRange(500,1000);
			tempCGIns    = RandRange(25000,40000);
			tempCol_Land = 2000;
			tempCol_Ore  = 1500;
			tempCol_Loy  = RandRange(1000,2000);
			tempCol_Pop  = 150;
			tempCol_Housing = 30;
			tempCol_Comm    = 50;
			tempCol_Agri    = 50;
			tempCol_Mining  = 12;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(20000,45000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 2) // Slow Server
		{
			tempcredit   = RandRange(800000,1500000);
			tempFoodIns  = RandRange(100000,350000);
			tempOreIns   = RandRange(1000,1500);
			tempCGIns    = RandRange(75000,200000);
			tempCol_Land = 2500;
			tempCol_Ore  = 2000;
			tempCol_Loy  = RandRange(1500,4000);
			tempCol_Pop  = 300;
			tempCol_Housing = 50;
			tempCol_Comm    = 75;
			tempCol_Agri    = 75;
			tempCol_Mining  = 15;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(35000,50000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 3) //Ultra Server
		{
			tempcredit   = RandRange(450000,750000);
			tempFoodIns  = RandRange(25000,37500);
			tempOreIns   = RandRange(400,900);
			tempCGIns    = RandRange(17500,35000);
			tempCol_Land = 1750;
			tempCol_Ore  = 1400;
			tempCol_Loy  = RandRange(700,1750);
			tempCol_Pop  = 150;
			tempCol_Housing = 30;
			tempCol_Comm    = 50;
			tempCol_Agri    = 50;
			tempCol_Mining  = 7;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(15000,35000);
				tempL = tempL + 1;
			}
		}
		else //RT, DM, & Not found
		{
			tempcredit   = RandRange(350000,750000);
			tempFoodIns  = RandRange(20000,30000);
			tempOreIns   = RandRange(200,400);
			tempCGIns    = RandRange(15000,25000);
			tempCol_Land = 1500;
			tempCol_Ore  = 1300;
			tempCol_Loy  = RandRange(500,1500);
			tempCol_Pop  = 100;
			tempCol_Housing = 10;
			tempCol_Comm    = 30;
			tempCol_Agri    = 50;
			tempCol_Mining  = 5;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(10000,30000);
				tempL = tempL + 1;
			}
		}
	}
	else if (temp_race is 6) //A.Miner Race
	{
		tempCol_Type  = 4; //Forest
		tempCol_Class = 1; //Homeworld
		tempCol_Min   = RandRange(1,6); //Random Mineral
		tempCol_Comm     = 0;

		if (temp_server is 0) //Normal Server
		{
			tempcredit   = RandRange(1250000,3500000);
			tempFoodIns  = RandRange(500000,1250000);
			tempOreIns   = RandRange(3000,5000);
			tempRMIns    = RandRange(250000,750000);
			tempCGIns    = RandRange(75000,125000);
			tempCol_Land = 3000;
			tempCol_Ore  = 2500;
			tempCol_Loy  = RandRange(2750,5000);
			tempCol_Pop  = 1000;
			tempCol_Housing = 100;
			tempCol_Industry = 400;
			tempCol_Agri    = 250;
			tempCol_Mining  = 45;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(55000,80000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 1) // Fast Server
		{
			tempcredit   = RandRange(900000,1250000);
			tempFoodIns  = RandRange(125000,250000);
			tempOreIns   = RandRange(1000,2500);
			tempRMIns    = RandRange(50000,100000);
			tempCGIns    = RandRange(25000,50000);
			tempCol_Land = 2500;
			tempCol_Ore  = 2000;
			tempCol_Loy  = RandRange(2000,4500);
			tempCol_Pop  = 500;
			tempCol_Housing = 50;
			tempCol_Industry = 250;
			tempCol_Agri    = 150;
			tempCol_Mining  = 30;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(40000,60000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 2) // Slow Server
		{
			tempcredit   = RandRange(2250000,5000000);
			tempFoodIns  = RandRange(750000,1750000);
			tempOreIns   = RandRange(5000,7000);
			tempRMIns    = RandRange(500000,1000000);
			tempCGIns    = RandRange(150000,500000);
			tempCol_Land = 3500;
			tempCol_Ore  = 3000;
			tempCol_Loy  = RandRange(3000,5000);
			tempCol_Pop  = 1000;
			tempCol_Housing = 100;
			tempCol_Industry = 400;
			tempCol_Agri    = 250;
			tempCol_Mining  = 45;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(55000,90000);
				tempL = tempL + 1;
			}
		}
		else if (temp_server is 3) //Ultra Server
		{
			tempcredit   = RandRange(750000,1200000);
			tempFoodIns  = RandRange(100000,175000);
			tempOreIns   = RandRange(750,1750);
			tempRMIns    = RandRange(40000,75000);
			tempCGIns    = RandRange(15000,40000);
			tempCol_Land = 2250;
			tempCol_Ore  = 1750;
			tempCol_Loy  = RandRange(1500,4000);
			tempCol_Pop  = 500;
			tempCol_Housing = 50;
			tempCol_Industry = 200;
			tempCol_Agri    = 100;
			tempCol_Mining  = 20;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(35000,50000);
				tempL = tempL + 1;
			}
		}
		else //RT, DM, & Not found
		{
			tempcredit   = RandRange(500000,1000000);
			tempFoodIns  = RandRange(50000,150000);
			tempOreIns   = RandRange(500,1500);
			tempRMIns    = RandRange(25000,50000);
			tempCGIns    = RandRange(10000,30000);
			tempCol_Land = 2000;
			tempCol_Ore  = 1500;
			tempCol_Loy  = RandRange(1000,4000);
			tempCol_Pop  = 200;
			tempCol_Housing = 20;
			tempCol_Industry = 100;
			tempCol_Agri    = 50;
			tempCol_Mining  = 15;

			while (tempL LTE 6) //Starting Mineral Generation
			{
				"tempGood_#tempL#" = RandRange(25000,40000);
				tempL = tempL + 1;
			}
		}
	}
	else if (temp_race is 7) //Kalzul Race
	{
		tempCol_Type  = 8; //Balanced
		tempCol_Class = 1; //Homeworld
		tempCol_Min   = 1; //Terran Metal
		tempCol_Land = 5000;
		tempCol_Ore  = 0;
		tempCol_Loy  = 5000;
		tempCol_Pop  = 10;
		tempCol_Housing = 1;
		tempCol_Comm    = 0;
		tempCol_Industry = 0;
		tempCol_Agri    = 0;
		tempCol_Mining  = 0;
		tempcredit  = 5000000000;
		tempFoodIns = 500000000;
		tempOreIns  = 500000000;
		tempCGIns   = 500000000;
		tempRMIns   = 500000000;
		tempGood_1  = 500000000;
		tempGood_2  = 500000000;
		tempGood_3  = 500000000;
		tempGood_4  = 500000000;
		tempGood_5  = 500000000;
		tempGood_6  = 500000000;
	}
	else //Just incase (Good to have default values)
	{
		tempCol_Type  = 8; //Balanced
		tempCol_Class = 1; //Homeworld
		tempCol_Min   = 1; //Terran Metal
		tempCol_Land = 500;
		tempCol_Ore  = 250;
		tempCol_Loy  = 50;
		tempCol_Pop  = 10;
		tempCol_Housing = 1;
		tempCol_Comm    = 0;
		tempCol_Industry = 0;
		tempCol_Agri    = 0;
		tempCol_Mining  = 1;
		tempcredit  = 50000;
		tempFoodIns = 20000;
		tempOreIns  = 0;
		tempCGIns   = 0;
		tempRMIns   = 0;
		tempGood_1  = 0;
		tempGood_2  = 0;
		tempGood_3  = 0;
		tempGood_4  = 0;
		tempGood_5  = 0;
		tempGood_6  = 0;
	}


	tempCol_Loy = tempCol_Loy - (tempCol_Loy MOD 5); //Ensures loyalty stays in a multiple of 5 (IE:- 3758 will become 3755)

	if (parameterexists(bonusflag)) tempcredit = tempcredit + (200000 * bonusflag); //Old Bonus code
</cfscript>

<!--- Check for and apply 7 day paid for new accounts ----- May see other uses ----- --->
<cfif temp_day_paid gt 0> <!--- This value can be found on the p_signup page. It is currently set to 7 days, and can be changed/expanded upon. --->
	<cfif temp_server lt 5>
		<Cfset temp_day_paid_exp = dateadd('d',+temp_day_paid,now())>

		<cfquery datasource="#ds#">
			update `user` set p_type=88, p_expire=#createodbcdatetime(temp_day_paid_exp)# where id=#temp_userid#
		</cfquery>
	</cfif>
</cfif>

<!--- Planet & Goods insert (Minerals/Artifacts) --->
<cfquery datasource="#ds#">
	insert into col
	(userid, type, goodid, land, loyalty, class, datetime, pop, ore, housing, commercial, industry, agriculture, mining)
	values
	(#temp_userid#, #tempCol_Type#, #tempCol_Min# , #tempCol_Land#, #tempCol_Loy#, #tempCol_Class#, #createodbcdatetime(now())#, #tempCol_Pop#, #tempCol_Ore#, #tempCol_Housing#, #tempCol_Comm#, #tempCol_Industry#, #tempCol_Agri#, #tempCol_Mining#)

	insert into user_good
	(id, g1, g2, g3, g4, g5, g6, #selfBTCID# server)
	values
	(#temp_userid#, #tempGood_1#, #tempGood_2#, #tempGood_3#, #tempGood_4#, #tempGood_5#, #tempGood_6#, #selfBTC# #temp_server#)
</cfquery>

<!--- Users Starting Minerals to Cache --->
<cflock name="#APPLICATION.applicationName#_usergood_#temp_userid#" type="Exclusive" timeout="20">
	<cfloop from="1" to="6" index=i>
		<cfset "application.usergood_#temp_userid#_#I#" = evaluate("tempGood_" & #I#)>
	</cfloop>
</cflock>

<!--- Last Tick for Turns! --->
<cfif isdefined("application.server#temp_server#_tournament_start")>
	<cfset temptick = evaluate("application.server#temp_server#_tournament_start")>
<cfelse>
	<cfset temptick = dateadd('d',-3,now())>
</cfif>

<!--- Final DB Account Update --->
<cfquery datasource="#ds#">
update `user` set
	race=#temp_race#, credit=#tempcredit#
	, r_research = '#evaluate("application.restree_r#temp_race#")#'
	, r_researched = '', r_ship = '#evaluate("application.shiptype_r#temp_race#")#'
	, r_1=0, r_2=0, r_3=0, r_4=0, r_5=0
	, annex=null
	, trade=0
	, ore=#tempOreIns#
	, food=#tempFoodIns#
	, rawmaterial=#tempRMIns#
	, good=#tempCGIns#
	, explore=0
	, resid=0
	, resstart=2
	, resreq=2
	, reslevel=0
	, restreeid=null
	, restreeturn=null
	, m_act=1, m_mission=1, m_finishflag=0
	, power = 1500
	, planetlost=0
	, protection=NULL
	, protection2=NULL
	, protectionstart=NULL
	, planetcount=1
	, colonycount=1
	, tick=#createodbcdatetime(temptick)#
	, p_startempire=#createodbcdatetime(now())#
where id=#temp_userid#
</cfquery>

<cfquery datasource="#DS#">
	DELETE FROM project_user
	WHERE userid = #temp_userid#
</cfquery>

<cfset session.EmpAge=createodbcdatetime(now())>

<!--- Users Last Tick (Turns) --->
<cflock name="#APPLICATION.applicationName#_tick_#temp_userid#" type="Exclusive" timeout="20">
	<cfif isdefined("application.user_#temp_userid#_tick")> <cfset "application.user_#temp_userid#_tick" = temptick> </cfif>
</cflock>

<!--- Sets Starting Ships & Research --->
<cflock name="#APPLICATION.applicationName#_res_#temp_userid#" type="Exclusive" timeout="20">
	<cfscript>
		"application.s_getvalue_user_#temp_userid#_r_research" = evaluate("application.restree_r#temp_race#");
		"application.s_getvalue_user_#temp_userid#_r_researched" = "";
		"application.s_getvalue_user_#temp_userid#_r_ship" = evaluate("application.shiptype_r#temp_race#");
	</cfscript>
</cflock>

<!--- Research Infra defaults --->
<cflock name="#APPLICATION.applicationName#_res_#temp_userid#" type="Exclusive" timeout="20">
	<cfscript>
		"application.s_getvalue_user_#temp_userid#_resstart" = 2;
		"application.s_getvalue_user_#temp_userid#_resreq" = 2;
		"application.s_getvalue_user_#temp_userid#_reslevel" = 0;
	</cfscript>
</cflock>

<!--- Clears Reserching cache --->
<cflock name="#APPLICATION.applicationName#_res_#temp_userid#" type="ReadOnly" timeout="20">
	<cfscript>
		if (isdefined("APPLICATION.s_getvalue_user_#temp_userid#_restreeturn")){ structDelete(APPLICATION,"s_getvalue_user_#temp_userid#_restreeturn"); }
		if (isdefined("APPLICATION.s_getvalue_user_#temp_userid#_restreeid")){ structDelete(APPLICATION,"s_getvalue_user_#temp_userid#_restreeid"); }
	</cfscript>
</cflock>

<!--- User Upkeep default --->
<cflock name="#APPLICATION.applicationName#_shipupkeep_#temp_userid#" type="ReadOnly" timeout="20">
	<cfset "application.shipupkeep_#temp_userid#" = 0>
</cflock>

<!--- Research infra client defaults --->
<cflock name="#APPLICATION.applicationName#_infrastructure_#temp_userid#" type="Exclusive" timeout="20">
	<cfscript>
		"application.research_infrastructure_#temp_userid#_1" = 0;
		"application.research_infrastructure_#temp_userid#_2" = 0;
		"application.research_infrastructure_#temp_userid#_3" = 0;
		"application.research_infrastructure_#temp_userid#_4" = 0;
		"application.research_infrastructure_#temp_userid#_5" = 0;
	</cfscript>
</cflock>

<!--- Damage taken client default (0) --->
<cflock name="#APPLICATION.applicationName#_user_#temp_userid#" type="Exclusive" timeout="20">
	<cfset "application.user_#temp_userid#_planetlost" = 0>
</cflock>

<!--- User cannot dig for 24 hours --->
<cflock name="#APPLICATION.applicationName#_artifact#temp_userid#" type="Exclusive" timeout="20">
	<cfset "application.artifact#temp_userid#" = 1>
</cflock>

<cfsetting enablecfoutputonly="no">
