/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.clumps.mixin;

import com.blamejared.clumps.ClumpsCommon;
import com.blamejared.clumps.helper.IClumpedOrb;
import com.blamejared.clumps.mixin.ExperienceOrbAccess;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ExperienceOrb.class})
public abstract class MixinExperienceOrb
extends Entity
implements IClumpedOrb {
    @Shadow
    private int f_147072_;
    @Shadow
    private int f_20767_;
    @Shadow
    private int f_20770_;
    @Unique
    public Map<Integer, Integer> clumps$clumpedMap;

    @Shadow
    protected abstract int m_147092_(Player var1, int var2);

    @Shadow
    private static boolean m_147088_(ExperienceOrb experienceOrb, int id, int value) {
        return false;
    }

    public MixinExperienceOrb(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"canMerge(Lnet/minecraft/world/entity/ExperienceOrb;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canMerge(ExperienceOrb experienceOrb, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(experienceOrb.m_6084_() && !this.m_7306_((Entity)experienceOrb) ? 1 : 0));
    }

    @Inject(method={"canMerge(Lnet/minecraft/world/entity/ExperienceOrb;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canMerge(ExperienceOrb experienceOrb, int i, int j, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)experienceOrb.m_6084_());
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playerTouch(Player player, CallbackInfo ci) {
        if (!this.f_19853_.f_46443_) {
            if (ClumpsCommon.pickupXPEvent.test(player, (ExperienceOrb)this)) {
                return;
            }
            player.f_36101_ = 0;
            player.m_7938_((Entity)this, 1);
            this.clumps$getClumpedMap().forEach((value, amount) -> {
                for (int i = 0; i < amount; ++i) {
                    int leftOver = this.m_147092_(player, (int)value);
                    if (leftOver <= 0) continue;
                    player.m_6756_(leftOver);
                }
            });
            this.m_146870_();
            ci.cancel();
        }
    }

    @Inject(method={"merge(Lnet/minecraft/world/entity/ExperienceOrb;)V"}, at={@At(value="INVOKE", target="net/minecraft/world/entity/ExperienceOrb.discard()V", shift=At.Shift.BEFORE)}, cancellable=true)
    public void merge(ExperienceOrb secondaryOrb, CallbackInfo ci) {
        Map<Integer, Integer> otherMap = ((IClumpedOrb)secondaryOrb).clumps$getClumpedMap();
        this.clumps$clumpedMap = Stream.of(this.clumps$getClumpedMap(), otherMap).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
        this.f_147072_ = this.clumps$getClumpedMap().values().stream().reduce(Integer::sum).orElse(1);
        this.f_20767_ = Math.min(this.f_20767_, ((ExperienceOrbAccess)secondaryOrb).getAge());
        secondaryOrb.m_146870_();
        ci.cancel();
    }

    @Inject(method={"tryMergeToExisting(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void tryMergeToExisting(ServerLevel serverLevel, Vec3 vec3, int value, CallbackInfoReturnable<Boolean> cir) {
        AABB aABB = AABB.m_165882_((Vec3)vec3, (double)1.0, (double)1.0, (double)1.0);
        int id = serverLevel.m_5822_().nextInt(40);
        List list = serverLevel.m_142425_(EntityTypeTest.m_156916_(ExperienceOrb.class), aABB, experienceOrbx -> MixinExperienceOrb.m_147088_(experienceOrbx, id, value));
        if (!list.isEmpty()) {
            ExperienceOrb experienceOrb = (ExperienceOrb)list.get(0);
            Map<Integer, Integer> clumpedMap = ((IClumpedOrb)experienceOrb).clumps$getClumpedMap();
            clumpedMap = Stream.of(clumpedMap, Collections.singletonMap(value, 1)).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
            ((IClumpedOrb)experienceOrb).clumps$setClumpedMap(clumpedMap);
            ((ExperienceOrbAccess)experienceOrb).setCount(clumpedMap.values().stream().reduce(Integer::sum).orElse(1));
            ((ExperienceOrbAccess)experienceOrb).setAge(0);
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        CompoundTag map = new CompoundTag();
        this.clumps$getClumpedMap().forEach((value, count) -> map.m_128405_("" + value, count.intValue()));
        compoundTag.m_128365_("clumpedMap", (Tag)map);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (compoundTag.m_128441_("clumpedMap")) {
            CompoundTag clumpedMap = compoundTag.m_128469_("clumpedMap");
            for (String s : clumpedMap.m_128431_()) {
                map.put(Integer.parseInt(s), clumpedMap.m_128451_(s));
            }
        } else {
            map.put(this.f_20770_, this.f_147072_);
        }
        this.clumps$setClumpedMap(map);
    }

    @Override
    public Map<Integer, Integer> clumps$getClumpedMap() {
        if (this.clumps$clumpedMap == null) {
            this.clumps$clumpedMap = new HashMap<Integer, Integer>();
            this.clumps$clumpedMap.put(this.f_20770_, 1);
        }
        return this.clumps$clumpedMap;
    }

    @Override
    public void clumps$setClumpedMap(Map<Integer, Integer> map) {
        this.clumps$clumpedMap = map;
    }
}

