/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.machine.ChillerRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineChillerScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ChillerRecipeCategory
extends ThermalRecipeCategory<ChillerRecipe> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public ChillerRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineChillerScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_CHILLER_BLOCK.m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(1);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(10);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(1), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(10), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends ChillerRecipe> getRecipeClass() {
        return ChillerRecipe.class;
    }

    public void setIngredients(ChillerRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        TCoreJeiPlugin.setInputIngredients((IIngredients)ingredients, (List)recipe.getInputFluids());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
    }

    public void setRecipe(IRecipeLayout layout, ChillerRecipe recipe, IIngredients ingredients) {
        List inputItems = ingredients.getInputs(VanillaTypes.ITEM);
        List inputFluids = ingredients.getInputs(VanillaTypes.FLUID);
        List outputItems = ingredients.getOutputs(VanillaTypes.ITEM);
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiItemStacks.init(0, true, 51, 14);
        guiItemStacks.init(1, false, 114, 23);
        guiFluidStacks.init(0, true, 25, 11, 16, 40, TCoreJeiPlugin.tankSize((int)8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.tankOverlay));
        if (!inputItems.isEmpty()) {
            guiItemStacks.set(0, (List)inputItems.get(0));
        }
        guiItemStacks.set(1, (List)outputItems.get(0));
        if (!inputFluids.isEmpty()) {
            guiFluidStacks.set(0, (List)inputFluids.get(0));
        }
        this.addDefaultItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 1);
        TCoreJeiPlugin.addDefaultFluidTooltipCallback((IGuiFluidStackGroup)guiFluidStacks);
    }

    public void draw(ChillerRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 78, 23);
        this.tankBackground.draw(matrixStack, 24, 10);
        this.speedBackground.draw(matrixStack, 52, 34);
        if (!recipe.getInputFluids().isEmpty()) {
            RenderHelper.drawFluid((PoseStack)matrixStack, (int)78, (int)23, (FluidStack)((FluidIngredient)recipe.getInputFluids().get(0)).getFluids()[0], (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 78, 23);
            this.progressFluid.draw(matrixStack, 78, 23);
        } else {
            this.progress.draw(matrixStack, 78, 23);
        }
        this.speed.draw(matrixStack, 52, 34);
    }
}

