/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.dynamo;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.dynamo.MagmaticFuel;
import cofh.thermal.expansion.client.gui.dynamo.DynamoMagmaticScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalFuelCategory;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class MagmaticFuelCategory
extends ThermalFuelCategory<MagmaticFuel> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public MagmaticFuelCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(DynamoMagmaticScreen.TEXTURE, 26, 11, 70, 62).addPadding(0, 0, 16, 78).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.DYNAMO_MAGMATIC_BLOCK.m_7705_());
        this.durationBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.duration = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends MagmaticFuel> getRecipeClass() {
        return MagmaticFuel.class;
    }

    public void setIngredients(MagmaticFuel fuel, IIngredients ingredients) {
        TCoreJeiPlugin.setInputIngredients((IIngredients)ingredients, (List)fuel.getInputFluids());
    }

    public void setRecipe(IRecipeLayout layout, MagmaticFuel fuel, IIngredients ingredients) {
        List inputFluids = ingredients.getInputs(VanillaTypes.FLUID);
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiFluidStacks.init(0, false, 34, 11, 16, 40, TCoreJeiPlugin.tankSize((int)8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.tankOverlay));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        TCoreJeiPlugin.addDefaultFluidTooltipCallback((IGuiFluidStackGroup)guiFluidStacks);
    }

    public void draw(MagmaticFuel fuel, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalFuel)fuel, matrixStack, mouseX, mouseY);
        this.tankBackground.draw(matrixStack, 33, 10);
    }
}

