/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.machine.PyrolyzerRecipeManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachinePyrolyzerContainer;
import cofh.thermal.lib.tileentity.MachineTileProcess;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class MachinePyrolyzerTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && PyrolyzerRecipeManager.instance().validRecipe(item));
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(4000);

    public MachinePyrolyzerTile(BlockPos pos, BlockState state) {
        super(TExpReferences.MACHINE_PYROLYZER_TILE, pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return PyrolyzerRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = PyrolyzerRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        List recipeOutputFluids = this.curRecipe.getOutputFluids((IMachineInventory)this);
        this.renderFluid = recipeOutputFluids.isEmpty() ? FluidStack.EMPTY : new FluidStack((FluidStack)recipeOutputFluids.get(0), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachinePyrolyzerContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }
}

