/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.PressRecipeManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachinePressContainer;
import cofh.thermal.lib.tileentity.MachineTileProcess;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.references.ThermalTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class MachinePressTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && PressRecipeManager.instance().validInput(item));
    protected ItemStorageCoFH dieSlot = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && PressRecipeManager.instance().validDie(item));
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(4000);

    public MachinePressTile(BlockPos pos, BlockState state) {
        super(TExpReferences.MACHINE_PRESS_TILE, pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.dieSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return PressRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = PressRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        List recipeOutputFluids = this.curRecipe.getOutputFluids((IMachineInventory)this);
        this.renderFluid = recipeOutputFluids.isEmpty() ? FluidStack.EMPTY : new FluidStack((FluidStack)recipeOutputFluids.get(0), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    protected void resolveInputs() {
        this.inputSlot.modify(-((Integer)this.itemInputCounts.get(0)).intValue());
        if (this.itemInputCounts.size() > 1 && !this.dieSlot.getItemStack().m_204117_(ThermalTags.Items.MACHINE_DIES)) {
            this.dieSlot.modify(-((Integer)this.itemInputCounts.get(1)).intValue());
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachinePressContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }
}

