/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.DelayedSupplier;
import slimeknights.mantle.registration.FluidBuilder;
import slimeknights.mantle.registration.ItemProperties;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;
import slimeknights.mantle.registration.object.FluidObject;

public class FluidDeferredRegister
extends DeferredRegisterWrapper<Fluid> {
    private final DeferredRegister<Block> blockRegister;
    private final DeferredRegister<Item> itemRegister;

    public FluidDeferredRegister(String modID) {
        super(Registry.f_122899_, modID);
        this.blockRegister = DeferredRegister.create((ResourceKey)Registry.f_122901_, (String)modID);
        this.itemRegister = DeferredRegister.create((ResourceKey)Registry.f_122904_, (String)modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.blockRegister.register(bus);
        this.itemRegister.register(bus);
    }

    public <I extends Fluid> RegistryObject<I> registerFluid(String name, Supplier<? extends I> sup) {
        return this.register.register(name, sup);
    }

    public <F extends ForgeFlowingFluid> FluidObject<F> register(String name, String tagName, FluidBuilder builder, Function<ForgeFlowingFluid.Properties, ? extends F> still, Function<ForgeFlowingFluid.Properties, ? extends F> flowing, Function<Supplier<? extends FlowingFluid>, ? extends LiquidBlock> block) {
        DelayedSupplier<ForgeFlowingFluid> stillDelayed = new DelayedSupplier<ForgeFlowingFluid>();
        DelayedSupplier<ForgeFlowingFluid> flowingDelayed = new DelayedSupplier<ForgeFlowingFluid>();
        RegistryObject blockObj = this.blockRegister.register(name + "_fluid", () -> (LiquidBlock)block.apply(stillDelayed));
        builder.bucket((Supplier<? extends Item>)this.itemRegister.register(name + "_bucket", () -> new BucketItem((Supplier)stillDelayed, ItemProperties.BUCKET_PROPS)));
        ForgeFlowingFluid.Properties props = builder.block((Supplier<? extends LiquidBlock>)blockObj).build(stillDelayed, flowingDelayed);
        RegistryObject<ForgeFlowingFluid> stillSup = this.registerFluid(name, () -> (ForgeFlowingFluid)still.apply(props));
        stillDelayed.setSupplier((Supplier<ForgeFlowingFluid>)stillSup);
        RegistryObject<ForgeFlowingFluid> flowingSup = this.registerFluid("flowing_" + name, () -> (ForgeFlowingFluid)flowing.apply(props));
        flowingDelayed.setSupplier((Supplier<ForgeFlowingFluid>)flowingSup);
        return new FluidObject<ForgeFlowingFluid>(this.resource(name), tagName, (Supplier<ForgeFlowingFluid>)stillSup, (Supplier<ForgeFlowingFluid>)flowingSup, (Supplier<LiquidBlock>)((Supplier<? extends LiquidBlock>)blockObj));
    }

    public <F extends ForgeFlowingFluid> FluidObject<F> register(String name, FluidBuilder builder, Function<ForgeFlowingFluid.Properties, ? extends F> still, Function<ForgeFlowingFluid.Properties, ? extends F> flowing, Function<Supplier<? extends FlowingFluid>, ? extends LiquidBlock> block) {
        return this.register(name, name, builder, still, flowing, block);
    }

    public <F extends ForgeFlowingFluid> FluidObject<F> register(String name, String tagName, FluidAttributes.Builder builder, Function<ForgeFlowingFluid.Properties, ? extends F> still, Function<ForgeFlowingFluid.Properties, ? extends F> flowing, Material material, int lightLevel) {
        return this.register(name, tagName, new FluidBuilder(builder.luminosity(lightLevel)).explosionResistance(100.0f), still, flowing, fluid -> new LiquidBlock(fluid, BlockBehaviour.Properties.m_60939_((Material)material).m_60910_().m_60978_(100.0f).m_60993_().m_60953_(state -> lightLevel)));
    }

    public <F extends ForgeFlowingFluid> FluidObject<F> register(String name, FluidAttributes.Builder builder, Function<ForgeFlowingFluid.Properties, ? extends F> still, Function<ForgeFlowingFluid.Properties, ? extends F> flowing, Material material, int lightLevel) {
        return this.register(name, name, builder, still, flowing, material, lightLevel);
    }

    public FluidObject<ForgeFlowingFluid> register(String name, String tagName, FluidAttributes.Builder builder, Material material, int lightLevel) {
        return this.register(name, tagName, builder, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, material, lightLevel);
    }

    public FluidObject<ForgeFlowingFluid> register(String name, FluidAttributes.Builder builder, Material material, int lightLevel) {
        return this.register(name, name, builder, material, lightLevel);
    }
}

