/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.element.AnimationToggleElement;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.StructureElement;
import slimeknights.mantle.client.screen.book.element.TextElement;

public class ContentStructure
extends PageContent {
    public static final transient ResourceLocation ID = Mantle.getResource("structure");
    public String title;
    public String data;
    public TextData[] description;
    public final transient StructureTemplate template = new StructureTemplate();
    public transient List<StructureTemplate.StructureBlockInfo> templateBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();

    @Override
    public void load() {
        BookRepository repo = this.parent.source;
        if (this.data == null || this.data.isEmpty()) {
            return;
        }
        ResourceLocation location = repo.getResourceLocation(this.data);
        Resource resource = repo.getResource(location);
        if (resource == null) {
            return;
        }
        try {
            CompoundTag compoundnbt = NbtIo.m_128939_((InputStream)resource.m_6679_());
            this.template.m_74638_(compoundnbt);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.templateBlocks = ((StructureTemplate.Palette)this.template.f_74482_.get(0)).m_74652_();
        for (int i = 0; i < this.templateBlocks.size(); ++i) {
            StructureTemplate.StructureBlockInfo info = this.templateBlocks.get(i);
            if (info.f_74676_ == Blocks.f_50016_.m_49966_()) {
                this.templateBlocks.remove(i);
                --i;
                continue;
            }
            if (!info.f_74676_.m_60795_()) continue;
            Mantle.logger.error("Found non-default air block in template " + this.data);
        }
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int y = this.getTitleHeight();
        if (this.title == null || this.title.isEmpty()) {
            y = 0;
        } else {
            this.addTitle(list, this.title);
        }
        int offset = 0;
        int structureSizeX = 182;
        int structureSizeY = 176 - y - 10;
        if (this.description != null && this.description.length > 0) {
            offset = 15;
            structureSizeX -= 2 * offset;
            structureSizeY -= 2 * offset;
            list.add(new TextElement(0, 166 - 2 * offset, 182, 2 * offset, this.description));
        }
        if (this.template != null && this.template.m_163801_() != BlockPos.f_121853_) {
            boolean showButtons = this.template.m_163801_().m_123342_() > 1;
            StructureElement structureElement = new StructureElement(offset, y, structureSizeX, structureSizeY, this.template, this.templateBlocks);
            list.add(structureElement);
            if (showButtons) {
                int col = book.appearance.structureButtonColor;
                int colHover = book.appearance.structureButtonColorHovered;
                int colToggled = book.appearance.structureButtonColorToggled;
                list.add(new AnimationToggleElement(182 - ArrowButton.ArrowType.REFRESH.w, 0, ArrowButton.ArrowType.REFRESH, col, colHover, colToggled, structureElement));
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

