/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.block.entity.MantleSignBlockEntity;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.item.LecternBookItem;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.recipe.crafting.ShapedFallbackRecipe;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe;
import slimeknights.mantle.recipe.helper.TagEmptyCondition;
import slimeknights.mantle.recipe.helper.TagPreference;
import slimeknights.mantle.recipe.ingredient.FluidContainerIngredient;
import slimeknights.mantle.registration.adapter.BlockEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.RegistryAdapter;
import slimeknights.mantle.util.OffhandCooldownTracker;

@Mod(value="mantle")
public class Mantle {
    public static final String modId = "mantle";
    public static final Logger logger = LogManager.getLogger((String)"Mantle");
    public static Mantle instance;

    public Mantle() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, this::commonSetup);
        bus.addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, this::registerCapabilities);
        bus.addGenericListener(RecipeSerializer.class, this::registerRecipeSerializers);
        bus.addGenericListener(BlockEntityType.class, this::registerBlockEntities);
        bus.addGenericListener(GlobalLootModifierSerializer.class, MantleLoot::registerGlobalLootModifiers);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.RightClickBlock.class, LecternBookItem::interactWithBlock);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        OffhandCooldownTracker.register(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MantleNetwork.registerPackets();
        MantleCommand.init();
        OffhandCooldownTracker.init();
        TagPreference.init();
    }

    private void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        RegistryAdapter adapter = new RegistryAdapter(event.getRegistry());
        adapter.register(new ShapedFallbackRecipe.Serializer(), "crafting_shaped_fallback");
        adapter.register(new ShapedRetexturedRecipe.Serializer(), "crafting_shaped_retextured");
        CraftingHelper.register((IConditionSerializer)TagEmptyCondition.SERIALIZER);
        CraftingHelper.register((ResourceLocation)FluidContainerIngredient.ID, (IIngredientSerializer)FluidContainerIngredient.SERIALIZER);
    }

    private void registerBlockEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        BlockEntityTypeRegistryAdapter adapter = new BlockEntityTypeRegistryAdapter((IForgeRegistry<BlockEntityType<?>>)event.getRegistry());
        adapter.register(MantleSignBlockEntity::new, "sign", MantleSignBlockEntity::buildSignBlocks);
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(modId, name);
    }
}

