/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureWaterloggedBlock;
import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.core.ModItems;
import com.mrcrayfish.furniture.item.crafting.GrillCookingRecipe;
import com.mrcrayfish.furniture.tileentity.GrillBlockEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrillBlock
extends FurnitureWaterloggedBlock
implements EntityBlock {
    public static final VoxelShape SHAPE = VoxelShapeHelper.combineAll(Arrays.asList(Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)11.0, (double)14.5)));

    public GrillBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof GrillBlockEntity) {
                GrillBlockEntity blockEntity2 = (GrillBlockEntity)blockEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, blockEntity2.getGrill());
                Containers.m_19010_((Level)level, (BlockPos)pos, blockEntity2.getFuel());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && result.m_82434_() == Direction.UP && (blockEntity = level.m_7702_(pos)) instanceof GrillBlockEntity) {
            GrillBlockEntity blockEntity2 = (GrillBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == ModItems.SPATULA.get()) {
                blockEntity2.flipItem(this.getPosition(result, pos));
            } else if (stack.m_41720_() == Items.f_42413_ || stack.m_41720_() == Items.f_42414_) {
                if (blockEntity2.addFuel(stack)) {
                    stack.m_41774_(1);
                    level.m_5594_(null, pos, SoundEvents.f_12654_, SoundSource.BLOCKS, 1.0f, 1.5f);
                }
            } else if (!stack.m_41619_()) {
                Optional<GrillCookingRecipe> optional = blockEntity2.findMatchingRecipe(stack);
                if (optional.isPresent()) {
                    GrillCookingRecipe recipe = optional.get();
                    if (blockEntity2.addItem(stack, this.getPosition(result, pos), recipe.m_43753_(), recipe.m_43750_(), (byte)player.m_6350_().m_122416_()) && !player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
            } else {
                blockEntity2.removeItem(this.getPosition(result, pos));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private int getPosition(BlockHitResult hit, BlockPos pos) {
        Vec3 hitVec = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        int position = 0;
        if (hitVec.m_7096_() > 0.5) {
            ++position;
        }
        if (hitVec.m_7094_() > 0.5) {
            position += 2;
        }
        return position;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GrillBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return GrillBlock.createMailBoxTicker(level, type, (BlockEntityType<? extends GrillBlockEntity>)((BlockEntityType)ModBlockEntities.GRILL.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createMailBoxTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends GrillBlockEntity> grillBlockEntity) {
        if (level.m_5776_()) {
            return GrillBlock.createTickerHelper(blockEntityType, grillBlockEntity, GrillBlockEntity::clientTick);
        }
        return GrillBlock.createTickerHelper(blockEntityType, grillBlockEntity, GrillBlockEntity::serverTick);
    }
}

