/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.item.UpgradeItem;
import com.hrznstudio.titanium.item.BasicItem;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class StorageUpgradeItem
extends UpgradeItem {
    private final StorageTier storageTier;

    public StorageUpgradeItem(StorageTier tier) {
        super(new Item.Properties(), UpgradeItem.Type.STORAGE);
        this.storageTier = tier;
    }

    public int getStorageMultiplier() {
        return this.storageTier.storageMultiplier;
    }

    public StorageTier getStorageTier() {
        return this.storageTier;
    }

    @Override
    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (this.storageTier == StorageTier.IRON) {
            tooltip.add((Component)new TranslatableComponent("item.utility.downgrade").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent("storageupgrade.desc").m_130940_(ChatFormatting.GRAY).m_130946_("" + this.storageTier.getStorageMultiplier()));
        }
    }

    @Override
    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack p_41458_) {
        Component component = super.m_7626_(p_41458_);
        if (component instanceof TranslatableComponent) {
            ((TranslatableComponent)component).m_6270_(Style.f_131099_.m_178520_(this.storageTier == StorageTier.NETHERITE && Minecraft.m_91087_().f_91073_ != null ? Color.HSBtoRGB((float)(Minecraft.m_91087_().f_91073_.m_46467_() % 360L) / 360.0f, 1.0f, 1.0f) : this.storageTier.getColor()));
        }
        return component;
    }

    public static enum StorageTier {
        COPPER(8, new Color(204, 109, 81).getRGB()),
        GOLD(16, new Color(233, 177, 21).getRGB()),
        DIAMOND(24, new Color(32, 197, 181).getRGB()),
        NETHERITE(32, new Color(49, 41, 42).getRGB()),
        IRON(1, new Color(130, 130, 130).getRGB());

        private final int storageMultiplier;
        private final int color;

        private StorageTier(int storageMultiplier, int color) {
            this.storageMultiplier = storageMultiplier;
            this.color = color;
        }

        public int getStorageMultiplier() {
            return this.storageMultiplier;
        }

        public int getColor() {
            return this.color;
        }
    }
}

