/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.DrawerControllerTile;
import com.buuz135.functionalstorage.block.tile.EnderDrawerTile;
import com.buuz135.functionalstorage.inventory.EnderInventoryHandler;
import com.buuz135.functionalstorage.world.EnderSavedData;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.item.BasicItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class LinkingToolItem
extends BasicItem {
    public static final String NBT_MODE = "Mode";
    public static final String NBT_CONTROLLER = "Controller";
    public static final String NBT_ACTION = "Action";
    public static final String NBT_FIRST = "First";
    public static final String NBT_ENDER = "Ender";
    public static final String NBT_ENDER_SAFETY = "EnderSafety";

    public static LinkingMode getLinkingMode(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_MODE)) {
            return LinkingMode.valueOf(stack.m_41784_().m_128461_(NBT_MODE));
        }
        return LinkingMode.SINGLE;
    }

    public static ActionMode getActionMode(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_ACTION)) {
            return ActionMode.valueOf(stack.m_41784_().m_128461_(NBT_ACTION));
        }
        return ActionMode.ADD;
    }

    public LinkingToolItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)FunctionalStorage.TAB).m_41487_(1));
    }

    public void m_7836_(ItemStack p_41447_, Level p_41448_, Player p_41449_) {
        super.m_7836_(p_41447_, p_41448_, p_41449_);
        this.initNbt(p_41447_);
    }

    private ItemStack initNbt(ItemStack stack) {
        stack.m_41784_().m_128359_(NBT_MODE, LinkingMode.SINGLE.name());
        stack.m_41784_().m_128359_(NBT_ACTION, ActionMode.ADD.name());
        return stack;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)this.initNbt(new ItemStack((ItemLike)this)));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128441_(NBT_ENDER);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EnderDrawerTile) {
            stack.m_41784_().m_128359_(NBT_ENDER, ((EnderDrawerTile)blockEntity).getFrequency());
            player.m_5661_((Component)new TextComponent("Stored frequency in the tool").m_6270_(Style.f_131099_.m_131148_(LinkingMode.SINGLE.color)), true);
            return false;
        }
        return super.m_6777_(state, level, pos, player);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        CompoundTag controllerNBT;
        BlockEntity controller;
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(pos);
        LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
        ActionMode linkingAction = LinkingToolItem.getActionMode(stack);
        if (blockEntity instanceof EnderDrawerTile && stack.m_41784_().m_128441_(NBT_ENDER)) {
            String frequency = stack.m_41784_().m_128461_(NBT_ENDER);
            EnderInventoryHandler inventory = EnderSavedData.getInstance((LevelAccessor)context.m_43725_()).getFrequency(((EnderDrawerTile)blockEntity).getFrequency());
            if (inventory.getStackInSlot(0).m_41619_() || context.m_43723_().m_6144_() && stack.m_41784_().m_128441_(NBT_ENDER)) {
                ((EnderDrawerTile)blockEntity).setFrequency(frequency);
                context.m_43723_().m_5661_((Component)new TextComponent("Changed drawer frequency").m_6270_(Style.f_131099_.m_131148_(linkingMode.color)), true);
                stack.m_41784_().m_128473_(NBT_ENDER_SAFETY);
            } else {
                context.m_43723_().m_5661_((Component)new TextComponent("Cannot change frequency, there are items in the drawer. Sneak + Right Click again to ignore this safety").m_130940_(ChatFormatting.RED), true);
                stack.m_41784_().m_128379_(NBT_ENDER_SAFETY, true);
            }
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof DrawerControllerTile) {
            CompoundTag controller2 = new CompoundTag();
            controller2.m_128405_("X", pos.m_123341_());
            controller2.m_128405_("Y", pos.m_123342_());
            controller2.m_128405_("Z", pos.m_123343_());
            stack.m_41784_().m_128365_(NBT_CONTROLLER, (Tag)controller2);
            context.m_43723_().m_5496_(SoundEvents.f_12013_, 0.5f, 1.0f);
            context.m_43723_().m_5661_((Component)new TextComponent("Controller configured to the tool").m_130940_(ChatFormatting.GREEN), true);
            stack.m_41784_().m_128473_(NBT_ENDER);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof ControllableDrawerTile && stack.m_41784_().m_128441_(NBT_CONTROLLER) && (controller = level.m_7702_(new BlockPos((controllerNBT = stack.m_41784_().m_128469_(NBT_CONTROLLER)).m_128451_("X"), controllerNBT.m_128451_("Y"), controllerNBT.m_128451_("Z")))) instanceof DrawerControllerTile) {
            if (linkingMode == LinkingMode.SINGLE) {
                ((ControllableDrawerTile)blockEntity).setControllerPos(controller.m_58899_());
                ((DrawerControllerTile)controller).addConnectedDrawers(linkingAction, pos);
                context.m_43723_().m_5661_((Component)new TextComponent("Linked drawer to the controller").m_6270_(Style.f_131099_.m_131148_(linkingMode.color)), true);
            } else if (stack.m_41784_().m_128441_(NBT_FIRST)) {
                CompoundTag firstpos = stack.m_41784_().m_128469_(NBT_FIRST);
                BlockPos firstPos = new BlockPos(firstpos.m_128451_("X"), firstpos.m_128451_("Y"), firstpos.m_128451_("Z"));
                AABB aabb = new AABB((double)Math.min(firstPos.m_123341_(), pos.m_123341_()), (double)Math.min(firstPos.m_123342_(), pos.m_123342_()), (double)Math.min(firstPos.m_123343_(), pos.m_123343_()), (double)(Math.max(firstPos.m_123341_(), pos.m_123341_()) + 1), (double)(Math.max(firstPos.m_123342_(), pos.m_123342_()) + 1), (double)(Math.max(firstPos.m_123343_(), pos.m_123343_()) + 1));
                ((DrawerControllerTile)controller).addConnectedDrawers(linkingAction, (BlockPos[])LinkingToolItem.getBlockPosInAABB(aabb).toArray(BlockPos[]::new));
                stack.m_41784_().m_128473_(NBT_FIRST);
            } else {
                CompoundTag firstPos = new CompoundTag();
                firstPos.m_128405_("X", pos.m_123341_());
                firstPos.m_128405_("Y", pos.m_123342_());
                firstPos.m_128405_("Z", pos.m_123343_());
                stack.m_41784_().m_128365_(NBT_FIRST, (Tag)firstPos);
            }
            context.m_43723_().m_5496_(SoundEvents.f_12017_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            if (stack.m_41784_().m_128441_(NBT_ENDER)) {
                if (player.m_6144_()) {
                    stack.m_41784_().m_128473_(NBT_ENDER);
                    player.m_5661_((Component)new TextComponent("Cleared drawer frequency").m_6270_(Style.f_131099_.m_131148_(ActionMode.ADD.getColor())), true);
                }
            } else if (player.m_6144_()) {
                LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
                if (linkingMode == LinkingMode.SINGLE) {
                    stack.m_41784_().m_128359_(NBT_MODE, LinkingMode.MULTIPLE.name());
                    player.m_5661_((Component)new TextComponent("Swapped mode to " + LinkingMode.MULTIPLE.name().toLowerCase(Locale.ROOT)).m_6270_(Style.f_131099_.m_131148_(LinkingMode.MULTIPLE.getColor())), true);
                } else {
                    stack.m_41784_().m_128359_(NBT_MODE, LinkingMode.SINGLE.name());
                    player.m_5661_((Component)new TextComponent("Swapped mode to " + LinkingMode.SINGLE.name().toLowerCase(Locale.ROOT)).m_6270_(Style.f_131099_.m_131148_(LinkingMode.SINGLE.getColor())), true);
                }
            } else {
                ActionMode linkingMode = LinkingToolItem.getActionMode(stack);
                if (linkingMode == ActionMode.ADD) {
                    stack.m_41784_().m_128359_(NBT_ACTION, ActionMode.REMOVE.name());
                    player.m_5661_((Component)new TextComponent("Swapped action to " + ActionMode.REMOVE.name().toLowerCase(Locale.ROOT)).m_6270_(Style.f_131099_.m_131148_(ActionMode.REMOVE.getColor())), true);
                } else {
                    stack.m_41784_().m_128359_(NBT_ACTION, ActionMode.ADD.name());
                    player.m_5661_((Component)new TextComponent("Swapped action to " + ActionMode.ADD.name().toLowerCase(Locale.ROOT)).m_6270_(Style.f_131099_.m_131148_(ActionMode.ADD.getColor())), true);
                }
            }
            player.m_5496_(SoundEvents.f_12016_, 0.5f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(p_41432_, player, hand);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
        ActionMode linkingAction = LinkingToolItem.getActionMode(stack);
        if (key == null) {
            if (stack.m_41784_().m_128441_(NBT_ENDER)) {
                TranslatableComponent text = new TranslatableComponent("linkingtool.ender.frequency");
                tooltip.add((Component)text.m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)new TextComponent(""));
                tooltip.add((Component)new TextComponent(""));
                tooltip.add((Component)new TranslatableComponent("linkingtool.ender.clear").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)new TranslatableComponent("linkingtool.linkingmode").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("linkingtool.linkingmode." + linkingMode.name().toLowerCase(Locale.ROOT)).m_130948_(Style.f_131099_.m_131148_(linkingMode.getColor()))));
                tooltip.add((Component)new TranslatableComponent("linkingtool.linkingaction").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("linkingtool.linkingaction." + linkingAction.name().toLowerCase(Locale.ROOT)).m_130948_(Style.f_131099_.m_131148_(linkingAction.getColor()))));
                if (stack.m_41784_().m_128441_(NBT_CONTROLLER)) {
                    tooltip.add((Component)new TranslatableComponent("linkingtool.controller").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TextComponent("" + stack.m_41784_().m_128469_(NBT_CONTROLLER).m_128451_("X") + ChatFormatting.WHITE + ", " + ChatFormatting.DARK_AQUA + stack.m_41784_().m_128469_(NBT_CONTROLLER).m_128451_("Y") + ChatFormatting.WHITE + ", " + ChatFormatting.DARK_AQUA + stack.m_41784_().m_128469_(NBT_CONTROLLER).m_128451_("Z")).m_130940_(ChatFormatting.DARK_AQUA)));
                } else {
                    tooltip.add((Component)new TranslatableComponent("linkingtool.controller").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TextComponent("???").m_130940_(ChatFormatting.DARK_AQUA)));
                }
                tooltip.add((Component)new TextComponent(""));
                tooltip.add((Component)new TranslatableComponent("linkingtool.linkingmode." + linkingMode.name().toLowerCase(Locale.ROOT) + ".desc").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)new TranslatableComponent("linkingtool.use").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public static List<BlockPos> getBlockPosInAABB(AABB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.f_82289_; y < axisAlignedBB.f_82292_; y += 1.0) {
            for (double x = axisAlignedBB.f_82288_; x < axisAlignedBB.f_82291_; x += 1.0) {
                for (double z = axisAlignedBB.f_82290_; z < axisAlignedBB.f_82293_; z += 1.0) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    static {
        EventManager.forge(PlayerInteractEvent.LeftClickBlock.class).filter(leftClickBlock -> leftClickBlock.getSide() == LogicalSide.SERVER && leftClickBlock.getItemStack().m_150930_((Item)FunctionalStorage.LINKING_TOOL.get())).process(leftClickBlock -> {
            ItemStack stack = leftClickBlock.getItemStack();
            BlockEntity blockEntity = leftClickBlock.getWorld().m_7702_(leftClickBlock.getPos());
            if (blockEntity instanceof EnderDrawerTile) {
                stack.m_41784_().m_128359_(NBT_ENDER, ((EnderDrawerTile)blockEntity).getFrequency());
                leftClickBlock.getPlayer().m_5661_((Component)new TextComponent("Stored frequency in the tool").m_6270_(Style.f_131099_.m_131148_(LinkingMode.SINGLE.color)), true);
                leftClickBlock.setCanceled(true);
            }
        }).subscribe();
    }

    public static enum LinkingMode {
        SINGLE(TextColor.m_131266_((int)Color.cyan.getRGB())),
        MULTIPLE(TextColor.m_131266_((int)Color.GREEN.getRGB()));

        private final TextColor color;

        private LinkingMode(TextColor color) {
            this.color = color;
        }

        public TextColor getColor() {
            return this.color;
        }
    }

    public static enum ActionMode {
        ADD(TextColor.m_131266_((int)new Color(40, 131, 250).getRGB())),
        REMOVE(TextColor.m_131266_((int)new Color(250, 145, 40).getRGB()));

        private final TextColor color;

        private ActionMode(TextColor color) {
            this.color = color;
        }

        public TextColor getColor() {
            return this.color;
        }
    }
}

