/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ArmoryCabinetInventoryHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    public List<ItemStack> stackList = this.create();

    public int getSlots() {
        return FunctionalStorageConfig.ARMORY_CABINET_SIZE;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.stackList.size()) {
            return this.stackList.get(slot);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.isValid(slot, stack)) {
            if (!simulate) {
                this.stackList.set(slot, stack);
                this.onChange();
            }
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public abstract void onChange();

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate) {
            ItemStack stack = this.stackList.set(slot, ItemStack.f_41583_);
            this.onChange();
            return stack;
        }
        return this.stackList.get(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isCertifiedStack(stack);
    }

    private boolean isValid(int slot, @NotNull ItemStack stack) {
        return !stack.m_41619_() && this.stackList.get(slot).m_41619_() && this.isCertifiedStack(stack);
    }

    private boolean isCertifiedStack(ItemStack stack) {
        if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent()) {
            return false;
        }
        return stack.m_41782_() || stack.m_41763_() || stack.m_41792_() || stack.m_41741_() == 1;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        for (int i = 0; i < this.stackList.size(); ++i) {
            ItemStack stack = this.stackList.get(i);
            if (stack.m_41619_()) continue;
            compoundTag.m_128365_("" + i, (Tag)stack.serializeNBT());
        }
        return compoundTag;
    }

    private List<ItemStack> create() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < FunctionalStorageConfig.ARMORY_CABINET_SIZE; ++i) {
            stackList.add(ItemStack.f_41583_);
        }
        return stackList;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stackList = this.create();
        for (String allKey : nbt.m_128431_()) {
            int pos = Integer.parseInt(allKey);
            if (pos >= this.stackList.size()) continue;
            this.stackList.set(pos, ItemStack.m_41712_((CompoundTag)nbt.m_128469_(allKey)));
        }
    }
}

