/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.tile.DrawerControllerTile;
import com.buuz135.functionalstorage.block.tile.EnderDrawerTile;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderDrawerBlock
extends RotatableBlock<EnderDrawerTile> {
    public static HashMap<String, List<ItemStack>> FREQUENCY_LOOK = new HashMap();

    public EnderDrawerBlock() {
        super("ender_drawer", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50265_), EnderDrawerTile.class);
        this.setItemGroup((CreativeModeTab)FunctionalStorage.TAB);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).m_61124_((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public static List<ItemStack> getFrequencyDisplay(String string) {
        return FREQUENCY_LOOK.computeIfAbsent(string, s -> {
            List minecraftItems = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item != Items.f_41852_ && item.getRegistryName().m_135827_().equals("minecraft") && !(item instanceof BlockItem)).collect(Collectors.toList());
            return Arrays.stream(string.split("-")).map(s1 -> new ItemStack((ItemLike)minecraftItems.get(Math.abs(s1.hashCode()) % minecraftItems.size()))).collect(Collectors.toList());
        });
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_);
        p_206840_1_.m_61104_(new Property[]{DrawerBlock.LOCKED});
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public BlockEntityType.BlockEntitySupplier<EnderDrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> new EnderDrawerTile((BasicTileBlock<EnderDrawerTile>)this, (BlockEntityType<EnderDrawerTile>)((BlockEntityType)((RegistryObject)FunctionalStorage.ENDER_DRAWER.getRight()).get()), blockPos, state);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return EnderDrawerBlock.getShapes(state, source, pos);
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        DrawerBlock.CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_1).get((Object)((Direction)state.m_61143_((Property)RotatableBlock.FACING_HORIZONTAL))).forEach(boxes::add);
        VoxelShape total = Shapes.m_83144_();
        boxes.add(total);
        return boxes;
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public boolean hasCustomBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return true;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        return TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, EnderDrawerTile.class).map(drawerTile -> drawerTile.onSlotActivated(player, hand, ray.m_82434_(), ray.m_82450_().f_82479_, ray.m_82450_().f_82480_, ray.m_82450_().f_82481_, this.getHit(state, worldIn, pos, player))).orElse(InteractionResult.PASS);
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, EnderDrawerTile.class).ifPresent(drawerTile -> drawerTile.onClicked(player, this.getHit(state, worldIn, pos, player)));
    }

    public int getHit(BlockState state, Level worldIn, BlockPos pos, Player player) {
        VoxelShape hit;
        HitResult result = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockHitResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockHitResult)((BlockHitResult)result), (Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null) {
            if (hit.equals(Shapes.m_83144_())) {
                return -1;
            }
            ArrayList shapes = new ArrayList(DrawerBlock.CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_1).get((Object)((Direction)state.m_61143_((Property)RotatableBlock.FACING_HORIZONTAL))));
            for (int i = 0; i < shapes.size(); ++i) {
                if (!Shapes.m_83157_((VoxelShape)((VoxelShape)shapes.get(i)), (VoxelShape)hit, (BooleanOp)BooleanOp.f_82689_)) continue;
                return i;
            }
        }
        return -1;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        CopyNbtFunction.Builder nbtBuilder = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
        nbtBuilder.m_80279_("frequency", "BlockEntityTag.frequency");
        return blockLootTables.droppingSelfWithNbt((ItemLike)this, nbtBuilder);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.m_122779_();
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, EnderDrawerTile.class).ifPresent(tile -> {
                if (tile.getControllerPos() != null) {
                    TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)tile.getControllerPos(), DrawerControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, pos));
                }
            });
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void m_5871_(ItemStack p_49816_, @Nullable BlockGetter p_49817_, List<Component> tooltip, TooltipFlag p_49819_) {
        super.m_5871_(p_49816_, p_49817_, tooltip, p_49819_);
        if (p_49816_.m_41782_()) {
            TranslatableComponent text = new TranslatableComponent("linkingtool.ender.frequency");
            tooltip.add((Component)text.m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)new TextComponent(""));
        }
    }
}

