/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.DrawerControllerTile;
import com.buuz135.functionalstorage.block.tile.DrawerTile;
import com.buuz135.functionalstorage.inventory.item.DrawerCapabilityProvider;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.recipe.DrawerlessWoodIngredient;
import com.buuz135.functionalstorage.util.IWoodType;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawerBlock
extends RotatableBlock<DrawerTile> {
    public static HashMap<FunctionalStorage.DrawerType, Multimap<Direction, VoxelShape>> CACHED_SHAPES;
    public static BooleanProperty LOCKED;
    private final FunctionalStorage.DrawerType type;
    private final IWoodType woodType;

    public DrawerBlock(IWoodType woodType, FunctionalStorage.DrawerType type) {
        super(woodType.getName() + "_" + type.getSlots(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)woodType.getPlanks()), DrawerTile.class);
        this.woodType = woodType;
        this.type = type;
        this.setItemGroup((CreativeModeTab)FunctionalStorage.TAB);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_);
        p_206840_1_.m_61104_(new Property[]{LOCKED});
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public BlockEntityType.BlockEntitySupplier<DrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> new DrawerTile((BasicTileBlock<DrawerTile>)this, (BlockEntityType<DrawerTile>)((BlockEntityType)FunctionalStorage.DRAWER_TYPES.get((Object)this.type).stream().filter(registryObjectRegistryObjectPair -> ((Block)((RegistryObject)registryObjectRegistryObjectPair.getLeft()).get()).equals((Object)this)).map(Pair::getRight).findFirst().get().get()), blockPos, state, this.type);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return DrawerBlock.getShapes(state, source, pos, this.type);
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos, FunctionalStorage.DrawerType type) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        CACHED_SHAPES.get((Object)type).get((Object)((Direction)state.m_61143_((Property)RotatableBlock.FACING_HORIZONTAL))).forEach(boxes::add);
        VoxelShape total = Shapes.m_83144_();
        boxes.add(total);
        return boxes;
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public boolean hasCustomBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return true;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        return TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, DrawerTile.class).map(drawerTile -> drawerTile.onSlotActivated(player, hand, ray.m_82434_(), ray.m_82450_().f_82479_, ray.m_82450_().f_82480_, ray.m_82450_().f_82481_, this.getHit(state, worldIn, pos, player))).orElse(InteractionResult.PASS);
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, DrawerTile.class).ifPresent(drawerTile -> drawerTile.onClicked(player, this.getHit(state, worldIn, pos, player)));
    }

    public int getHit(BlockState state, Level worldIn, BlockPos pos, Player player) {
        VoxelShape hit;
        HitResult result = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockHitResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockHitResult)((BlockHitResult)result), (Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null) {
            if (hit.equals(Shapes.m_83144_())) {
                return -1;
            }
            ArrayList shapes = new ArrayList();
            shapes.addAll(CACHED_SHAPES.get((Object)this.type).get((Object)((Direction)state.m_61143_((Property)RotatableBlock.FACING_HORIZONTAL))));
            for (int i = 0; i < shapes.size(); ++i) {
                if (!Shapes.m_83157_((VoxelShape)((VoxelShape)shapes.get(i)), (VoxelShape)hit, (BooleanOp)BooleanOp.f_82689_)) continue;
                return i;
            }
        }
        return -1;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder builder) {
        NonNullList stacks = NonNullList.m_122779_();
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity drawerTile = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (drawerTile instanceof DrawerTile && !((DrawerTile)drawerTile).isEverythingEmpty()) {
            stack.m_41784_().m_128365_("Tile", (Tag)drawerTile.m_187482_());
        }
        stacks.add((Object)stack);
        return stacks;
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.m_122779_();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity p_49850_, ItemStack stack) {
        BlockEntity entity;
        super.m_6402_(level, pos, p_49849_, p_49850_, stack);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Tile") && (entity = level.m_7702_(pos)) instanceof DrawerTile) {
            entity.m_142466_(stack.m_41783_().m_128469_("Tile"));
            ((DrawerTile)entity).markForUpdate();
        }
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        if (this.type == FunctionalStorage.DrawerType.X_1) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).m_126130_("PPP").m_126130_("PCP").m_126130_("PPP").m_126127_(Character.valueOf('P'), (ItemLike)this.woodType.getPlanks()).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_176498_(consumer);
            if (this.woodType.getName().equals("oak")) {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).setName(new ResourceLocation(FunctionalStorage.MOD_ID, "oak_drawer_alternate_x1")).m_126130_("PPP").m_126130_("PCP").m_126130_("PPP").m_126124_(Character.valueOf('P'), (Ingredient)new DrawerlessWoodIngredient()).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_176498_(consumer);
            }
        }
        if (this.type == FunctionalStorage.DrawerType.X_2) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)2).m_126130_("PCP").m_126130_("PPP").m_126130_("PCP").m_126127_(Character.valueOf('P'), (ItemLike)this.woodType.getPlanks()).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_176498_(consumer);
            if (this.woodType.getName().equals("oak")) {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)2).setName(new ResourceLocation(FunctionalStorage.MOD_ID, "oak_drawer_alternate_x2")).m_126130_("PCP").m_126130_("PPP").m_126130_("PCP").m_126124_(Character.valueOf('P'), (Ingredient)new DrawerlessWoodIngredient()).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_176498_(consumer);
            }
        }
        if (this.type == FunctionalStorage.DrawerType.X_4) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)4).m_126130_("CPC").m_126130_("PPP").m_126130_("CPC").m_126127_(Character.valueOf('P'), (ItemLike)this.woodType.getPlanks()).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_176498_(consumer);
            if (this.woodType.getName().equals("oak")) {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)4).setName(new ResourceLocation(FunctionalStorage.MOD_ID, "oak_drawer_alternate_x4")).m_126130_("CPC").m_126130_("PPP").m_126130_("CPC").m_126124_(Character.valueOf('P'), (Ingredient)new DrawerlessWoodIngredient()).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_176498_(consumer);
            }
        }
    }

    public FunctionalStorage.DrawerType getType() {
        return this.type;
    }

    public IWoodType getWoodType() {
        return this.woodType;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, DrawerTile.class).ifPresent(tile -> {
                if (tile.getControllerPos() != null) {
                    TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)tile.getControllerPos(), DrawerControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, pos));
                }
            });
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void m_5871_(ItemStack p_49816_, @Nullable BlockGetter p_49817_, List<Component> tooltip, TooltipFlag p_49819_) {
        super.m_5871_(p_49816_, p_49817_, tooltip, p_49819_);
        if (p_49816_.m_41782_()) {
            TranslatableComponent text = new TranslatableComponent("drawer.block.contents");
            tooltip.add((Component)text.m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)new TextComponent(""));
        }
    }

    static {
        AABB bounding;
        CACHED_SHAPES = new HashMap();
        LOCKED = BooleanProperty.m_61465_((String)"locked");
        CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_1, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)Direction.NORTH, (Object)Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.0625));
        CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_1, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)Direction.SOUTH, (Object)Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375, (double)1.0));
        CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_1, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)Direction.WEST, (Object)Shapes.m_83048_((double)0.0, (double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375));
        CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_1, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)Direction.EAST, (Object)Shapes.m_83048_((double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375));
        for (Direction direction : CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_1).keySet()) {
            for (VoxelShape voxelShape : CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_1).get((Object)direction)) {
                bounding = (AABB)voxelShape.m_83299_().get(0);
                CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_2, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)bounding.f_82288_, (double)bounding.f_82289_, (double)bounding.f_82290_, (double)bounding.f_82291_, (double)0.4375, (double)bounding.f_82293_));
                CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_2, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)bounding.f_82288_, (double)0.5625, (double)bounding.f_82290_, (double)bounding.f_82291_, (double)bounding.f_82292_, (double)bounding.f_82293_));
            }
        }
        for (Direction direction : CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_2).keySet()) {
            for (VoxelShape voxelShape : CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_2).get((Object)direction)) {
                bounding = (AABB)voxelShape.m_83299_().get(0);
                if (direction == Direction.SOUTH) {
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)0.5625, (double)bounding.f_82289_, (double)bounding.f_82290_, (double)bounding.f_82291_, (double)bounding.f_82292_, (double)bounding.f_82293_));
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)bounding.f_82288_, (double)bounding.f_82289_, (double)bounding.f_82290_, (double)0.4375, (double)bounding.f_82292_, (double)bounding.f_82293_));
                    continue;
                }
                if (direction == Direction.NORTH) {
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)bounding.f_82288_, (double)bounding.f_82289_, (double)bounding.f_82290_, (double)0.4375, (double)bounding.f_82292_, (double)bounding.f_82293_));
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)0.5625, (double)bounding.f_82289_, (double)bounding.f_82290_, (double)bounding.f_82291_, (double)bounding.f_82292_, (double)bounding.f_82293_));
                    continue;
                }
                if (direction == Direction.EAST) {
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)bounding.f_82288_, (double)bounding.f_82289_, (double)bounding.f_82290_, (double)bounding.f_82291_, (double)bounding.f_82292_, (double)0.4375));
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)bounding.f_82288_, (double)bounding.f_82289_, (double)0.5625, (double)bounding.f_82291_, (double)bounding.f_82292_, (double)bounding.f_82293_));
                    continue;
                }
                CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)bounding.f_82288_, (double)bounding.f_82289_, (double)0.5625, (double)bounding.f_82291_, (double)bounding.f_82292_, (double)bounding.f_82293_));
                CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.m_83048_((double)bounding.f_82288_, (double)bounding.f_82289_, (double)bounding.f_82290_, (double)bounding.f_82291_, (double)bounding.f_82292_, (double)0.4375));
            }
        }
    }

    public static class DrawerItem
    extends BlockItem {
        private DrawerBlock drawerBlock;

        public DrawerItem(DrawerBlock p_40565_, Item.Properties p_40566_) {
            super((Block)p_40565_, p_40566_);
            this.drawerBlock = p_40565_;
        }

        public Optional<TooltipComponent> m_142422_(ItemStack stack) {
            return super.m_142422_(stack);
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            return new DrawerCapabilityProvider(stack, this.drawerBlock.getType());
        }
    }
}

