/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.tile.CompactingDrawerTile;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.DrawerControllerTile;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.util.StorageTags;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompactingDrawerBlock
extends RotatableBlock<CompactingDrawerTile> {
    public static Multimap<Direction, VoxelShape> CACHED_SHAPES = MultimapBuilder.hashKeys().arrayListValues().build();

    public CompactingDrawerBlock(String name) {
        super(name, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_), CompactingDrawerTile.class);
        this.setItemGroup((CreativeModeTab)FunctionalStorage.TAB);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).m_61124_((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public BlockEntityType.BlockEntitySupplier<CompactingDrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> new CompactingDrawerTile((BasicTileBlock<CompactingDrawerTile>)this, (BlockEntityType<CompactingDrawerTile>)((BlockEntityType)((RegistryObject)FunctionalStorage.COMPACTING_DRAWER.getRight()).get()), blockPos, state);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return CompactingDrawerBlock.getShapes(state, source, pos);
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        CACHED_SHAPES.get((Object)((Direction)state.m_61143_((Property)RotatableBlock.FACING_HORIZONTAL))).forEach(boxes::add);
        VoxelShape total = Shapes.m_83144_();
        boxes.add(total);
        return boxes;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_);
        p_206840_1_.m_61104_(new Property[]{DrawerBlock.LOCKED});
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public boolean hasCustomBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return true;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        return TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, CompactingDrawerTile.class).map(drawerTile -> drawerTile.onSlotActivated(player, hand, ray.m_82434_(), ray.m_82450_().f_82479_, ray.m_82450_().f_82480_, ray.m_82450_().f_82481_, this.getHit(state, worldIn, pos, player))).orElse(InteractionResult.PASS);
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, CompactingDrawerTile.class).ifPresent(drawerTile -> drawerTile.onClicked(player, this.getHit(state, worldIn, pos, player)));
    }

    public int getHit(BlockState state, Level worldIn, BlockPos pos, Player player) {
        VoxelShape hit;
        HitResult result = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockHitResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockHitResult)((BlockHitResult)result), (Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null) {
            if (hit.equals(Shapes.m_83144_())) {
                return -1;
            }
            ArrayList shapes = new ArrayList(CACHED_SHAPES.get((Object)((Direction)state.m_61143_((Property)RotatableBlock.FACING_HORIZONTAL))));
            for (int i = 0; i < shapes.size(); ++i) {
                if (!Shapes.m_83157_((VoxelShape)((VoxelShape)shapes.get(i)), (VoxelShape)hit, (BooleanOp)BooleanOp.f_82689_)) continue;
                return i;
            }
        }
        return -1;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder builder) {
        NonNullList stacks = NonNullList.m_122779_();
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity drawerTile = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (drawerTile instanceof ControllableDrawerTile && !((ControllableDrawerTile)drawerTile).isEverythingEmpty()) {
            stack.m_41784_().m_128365_("Tile", (Tag)drawerTile.m_187482_());
        }
        stacks.add((Object)stack);
        return stacks;
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.m_122779_();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity p_49850_, ItemStack stack) {
        BlockEntity entity;
        super.m_6402_(level, pos, p_49849_, p_49850_, stack);
        if (stack.m_41782_() && (entity = level.m_7702_(pos)) instanceof ControllableDrawerTile && stack.m_41783_().m_128441_("Tile")) {
            entity.m_142466_(stack.m_41783_().m_128469_("Tile"));
            ((ControllableDrawerTile)entity).markForUpdate();
        }
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).m_126130_("SSS").m_126130_("PDP").m_126130_("SIS").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50069_).m_126127_(Character.valueOf('P'), (ItemLike)Blocks.f_50039_).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_176498_(consumer);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, CompactingDrawerTile.class).ifPresent(tile -> {
                if (tile.getControllerPos() != null) {
                    TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)tile.getControllerPos(), DrawerControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, pos));
                }
            });
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    static {
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.0, (double)0.4375, (double)0.4375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.m_83048_((double)0.5625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.4375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.m_83048_((double)0.0625, (double)0.5625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.m_83048_((double)0.5625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.4375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.9375, (double)0.4375, (double)0.4375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.m_83048_((double)0.0625, (double)0.5625, (double)0.9375, (double)0.9375, (double)0.9375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.m_83048_((double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.4375, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.m_83048_((double)0.9375, (double)0.0625, (double)0.5625, (double)1.0, (double)0.4375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.m_83048_((double)0.9375, (double)0.5625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.m_83048_((double)0.0, (double)0.0625, (double)0.5625, (double)0.0625, (double)0.4375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.m_83048_((double)0.0, (double)0.0625, (double)0.0625, (double)0.0625, (double)0.4375, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.m_83048_((double)0.0, (double)0.5625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375));
    }
}

