/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import twilightforest.block.TFBlocks;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFGenHollowTree;

public class TFGenTreeOfTime
extends TFGenHollowTree {
    public TFGenTreeOfTime(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    public boolean generate(WorldGenLevel world, Random random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, BiConsumer<BlockPos, BlockState> decorationPlacer, TFTreeFeatureConfig config) {
        int height = 8;
        boolean diameter = true;
        if (world.m_151562_(pos.m_123342_() + 1) || world.m_151562_(pos.m_123342_() + 8 + 1)) {
            return false;
        }
        BlockState state = world.m_8055_(pos.m_7495_());
        if (!state.m_60734_().canSustainPlant(state, (BlockGetter)world, pos.m_7495_(), Direction.UP, (IPlantable)TFBlocks.TIME_SAPLING.get())) {
            return false;
        }
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, 1, 1, 0, 12, 0.75, 3, 5, 3, false, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, 1, 1, 2, 18, 0.9, 3, 5, 3, false, config);
        this.buildTrunk((LevelAccessor)world, trunkPlacer, decorationPlacer, random, pos, 1, 8, config);
        this.buildTinyCrown(world, trunkPlacer, leavesPlacer, random, pos, 1, 8, config);
        world.m_7731_(pos.m_142082_(-1, 2, 0), (BlockState)((Block)TFBlocks.TIME_LOG_CORE.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y), 3);
        return true;
    }

    protected void buildTinyCrown(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, Random random, BlockPos pos, int diameter, int height, TFTreeFeatureConfig config) {
        int crownRadius = 4;
        boolean bvar = true;
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height - 4, 0, 4, 0.35, 1, 3, 1, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height - 2, 0, 4, 0.28, 1, 3, 1, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, 0, 4, 0.15, 2, 4, 0, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, 0, 2, 0.05, 1, 3, 0, true, config);
    }
}

