/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import twilightforest.block.TFBlocks;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.feature.config.ThornsConfig;

public class TwilightThorns
extends Feature<ThornsConfig> {
    public TwilightThorns(Codec<ThornsConfig> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<ThornsConfig> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        Random rand = ctx.m_159776_();
        int nextLength = 2 + rand.nextInt(4);
        int maxLength = 2 + rand.nextInt(4) + rand.nextInt(4) + rand.nextInt(4);
        this.placeThorns(world, rand, pos, nextLength, Direction.UP, maxLength, pos, (ThornsConfig)ctx.m_159778_(), true);
        return true;
    }

    private void placeThorns(WorldGenLevel world, Random rand, BlockPos pos, int length, Direction dir, int maxLength, BlockPos oPos, ThornsConfig config, boolean avoidGiantCloud) {
        Direction nextDir;
        int middle;
        boolean complete = false;
        for (int i = 0; i < length; ++i) {
            BlockPos dPos = pos.m_5484_(dir, i);
            if (avoidGiantCloud && dPos.m_123342_() - 64 > WorldUtil.getBaseHeight((LevelAccessor)world, dPos.m_123341_(), dPos.m_123343_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES) || Math.abs(dPos.m_123341_() - oPos.m_123341_()) >= config.maxSpread() || Math.abs(dPos.m_123343_() - oPos.m_123343_()) >= config.maxSpread() || !this.canPlaceThorns((LevelAccessor)world, dPos)) break;
            world.m_7731_(dPos, (BlockState)((Block)TFBlocks.BROWN_THORNS.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_()), 3);
            if (i != length - 1) continue;
            complete = true;
            if (rand.nextInt(config.chanceOfLeaf()) != 0 || !world.m_46859_(dPos.m_142300_(dir))) continue;
            if (rand.nextInt(config.chanceLeafIsRose()) > 0) {
                world.m_7731_(dPos.m_142300_(dir), (BlockState)((Block)TFBlocks.THORN_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), 3);
                continue;
            }
            world.m_7731_(dPos.m_142300_(dir), ((Block)TFBlocks.THORN_ROSE.get()).m_49966_(), 3);
        }
        if (complete && maxLength > 1) {
            Direction nextDir2 = Direction.m_122404_((Random)rand);
            BlockPos nextPos = pos.m_5484_(dir, length - 1).m_142300_(nextDir2);
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir2, maxLength - 1, oPos, config, false);
        }
        if (complete && length > 3 && rand.nextInt(config.chanceOfBranch()) == 0) {
            middle = rand.nextInt(length);
            nextDir = Direction.m_122404_((Random)rand);
            BlockPos nextPos = pos.m_5484_(dir, middle).m_142300_(nextDir);
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir, maxLength - 1, oPos, config, false);
        }
        if (complete && length > 3 && rand.nextInt(config.chanceOfLeaf()) == 0) {
            middle = rand.nextInt(length);
            nextDir = Direction.m_122404_((Random)rand);
            BlockPos nextPos = pos.m_5484_(dir, middle).m_142300_(nextDir);
            if (world.m_46859_(nextPos)) {
                world.m_7731_(nextPos, ((Block)TFBlocks.THORN_LEAVES.get()).m_49966_(), 3);
            }
        }
    }

    private boolean canPlaceThorns(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60795_() || state.m_204336_(BlockTags.f_13035_);
    }
}

