/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;
import twilightforest.block.HollowLogHorizontal;
import twilightforest.block.TFBlocks;
import twilightforest.enums.HollowLogVariants;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.HollowLogConfig;

public class TFGenFallenSmallLog
extends Feature<HollowLogConfig> {
    public TFGenFallenSmallLog(Codec<HollowLogConfig> configIn) {
        super(configIn);
    }

    public boolean m_142674_(FeaturePlaceContext<HollowLogConfig> ctx) {
        BlockState branchState;
        WorldGenLevel world = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        Random rand = ctx.m_159776_();
        HollowLogConfig config = (HollowLogConfig)ctx.m_159778_();
        boolean shouldMakeAllHollow = rand.nextBoolean();
        boolean goingX = rand.nextBoolean();
        int length = rand.nextInt(4) + 3;
        if (goingX ? !FeatureUtil.isAreaSuitable(world, pos, length, 2, 2, true) : !FeatureUtil.isAreaSuitable(world, pos, 2, 2, length, true)) {
            return false;
        }
        BlockState logState = config.normal();
        BlockState hollowLogState = config.hollow();
        if (config.hollow().m_60795_()) {
            hollowLogState = null;
        }
        if (rand.nextInt(5) == 0 && world.m_8055_(pos).m_60767_() == Material.f_76305_) {
            BlockPos.MutableBlockPos floatingPos = pos.m_122032_();
            for (int i = 0; i < 10; ++i) {
                if (world.m_8055_(floatingPos.m_7494_()).m_60795_()) {
                    pos = floatingPos.m_7949_();
                    break;
                }
                floatingPos.m_122184_(0, 1, 0);
            }
        }
        if (goingX) {
            logState = (BlockState)logState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
            if (hollowLogState != null) {
                hollowLogState = (BlockState)((BlockState)hollowLogState.m_61124_(HollowLogHorizontal.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).m_61124_(HollowLogHorizontal.VARIANT, (Comparable)((Object)this.determineHollowProperties(world, pos, rand)));
            }
            branchState = (BlockState)logState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
            for (int lx = 0; lx < length; ++lx) {
                world.m_7731_(pos.m_142082_(lx, 0, 1), this.hollowOrNormal(world, shouldMakeAllHollow, hollowLogState, logState), 3);
                if (rand.nextInt(3) <= 0) continue;
                world.m_7731_(pos.m_142082_(lx, 1, 1), this.mossOrSeagrass(world, pos.m_142082_(lx, 1, 1)), 3);
                this.m_159739_(world, pos.m_142082_(lx, 0, 1));
            }
        } else {
            logState = (BlockState)logState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
            if (hollowLogState != null) {
                hollowLogState = (BlockState)((BlockState)hollowLogState.m_61124_(HollowLogHorizontal.HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z)).m_61124_(HollowLogHorizontal.VARIANT, (Comparable)((Object)this.determineHollowProperties(world, pos, rand)));
            }
            branchState = (BlockState)logState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
            for (int lz = 0; lz < length; ++lz) {
                world.m_7731_(pos.m_142082_(1, 0, lz), this.hollowOrNormal(world, shouldMakeAllHollow, hollowLogState, logState), 3);
                if (rand.nextInt(3) <= 0) continue;
                world.m_7731_(pos.m_142082_(1, 1, lz), this.mossOrSeagrass(world, pos.m_142082_(1, 1, lz)), 3);
                this.m_159739_(world, pos.m_142082_(1, 0, lz));
            }
        }
        if (rand.nextInt(3) > 0) {
            int bz;
            int bx;
            if (goingX) {
                bx = rand.nextInt(length);
                bz = rand.nextBoolean() ? 2 : 0;
            } else {
                bx = rand.nextBoolean() ? 2 : 0;
                bz = rand.nextInt(length);
            }
            world.m_7731_(pos.m_142082_(bx, 0, bz), branchState, 3);
            if (rand.nextBoolean()) {
                world.m_7731_(pos.m_142082_(bx, 1, bz), this.mossOrSeagrass(world, pos.m_142082_(bx, 1, bz)), 3);
                this.m_159739_(world, pos.m_142082_(bx, 0, bz));
            }
        }
        return true;
    }

    private BlockState mossOrSeagrass(WorldGenLevel level, BlockPos pos) {
        if (level.m_8055_(pos.m_6625_(2)).m_60767_() == Material.f_76280_) {
            return Blocks.f_50016_.m_49966_();
        }
        return level.m_8055_(pos).m_60767_() == Material.f_76305_ ? Blocks.f_50037_.m_49966_() : ((Block)TFBlocks.MOSS_PATCH.get()).m_49966_();
    }

    private BlockState hollowOrNormal(WorldGenLevel level, boolean shouldBeHollow, BlockState hollow, BlockState normal) {
        return (shouldBeHollow || level.m_5822_().nextInt(3) == 0) && hollow != null ? hollow : normal;
    }

    private HollowLogVariants.Horizontal determineHollowProperties(WorldGenLevel world, BlockPos pos, Random rand) {
        return world.m_8055_(pos).m_60767_() == Material.f_76305_ ? HollowLogVariants.Horizontal.WATERLOGGED : (world.m_8055_(pos).m_204336_(BlockTags.f_144279_) ? HollowLogVariants.Horizontal.SNOW : (rand.nextInt(5) == 0 ? HollowLogVariants.Horizontal.MOSS_AND_GRASS : (rand.nextInt(3) == 0 ? HollowLogVariants.Horizontal.MOSS : HollowLogVariants.Horizontal.EMPTY)));
    }
}

