/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components;

import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import twilightforest.TwilightForestMod;

public class BiomeGrassColors {
    private static final Random COLOR_RNG = new Random();
    public static final BiomeSpecialEffects.GrassColorModifier ENCHANTED_FOREST = BiomeGrassColors.make("enchanted_forest", (x, z, color) -> (color & 0xFFFF00) + BiomeGrassColors.getEnchantedColor((int)x, (int)z));
    public static final BiomeSpecialEffects.GrassColorModifier SWAMP = BiomeGrassColors.make("swamp", (x, z, color) -> ((GrassColor.m_46415_((double)0.8f, (double)0.9f) & 0xFEFEFE) + 0x4E0E4E) / 2);
    public static final BiomeSpecialEffects.GrassColorModifier DARK_FOREST = BiomeGrassColors.make("dark_forest", (x, z, color) -> ((GrassColor.m_46415_((double)0.7f, (double)0.8f) & 0xFEFEFE) + 1969742) / 2);
    public static final BiomeSpecialEffects.GrassColorModifier DARK_FOREST_CENTER = BiomeGrassColors.make("dark_forest_center", (x, z, color) -> {
        double d0 = Biome.f_47435_.m_75449_(x * 0.0225, z * 0.0225, false);
        return d0 < -0.2 ? 6714688 : 0x554114;
    });
    public static final BiomeSpecialEffects.GrassColorModifier SPOOKY_FOREST = BiomeGrassColors.make("spooky_forest", (x, z, color) -> {
        double noise = (Biome.f_47435_.m_75449_(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
        return BiomeGrassColors.blendColors(12865827, 11650083, noise > 0.6 ? noise * 0.1 : noise);
    });

    public static int getEnchantedColor(int x, int z) {
        int randomFlicker;
        int cx = 256 * Math.round((float)(x - 8) / 256.0f) + 8;
        int cz = 256 * Math.round((float)(z - 8) / 256.0f) + 8;
        int dist = (int)Mth.m_14116_((float)((cx - x) * (cx - x) + (cz - z) * (cz - z)));
        int color = dist * 64;
        if ((color %= 512) > 255) {
            color = 511 - color;
        }
        if (0 < (color = 255 - color) + (randomFlicker = COLOR_RNG.nextInt(32) - 16) && color + randomFlicker > 255) {
            color += randomFlicker;
        }
        return color;
    }

    public static int blendColors(int a, int b, double ratio) {
        int mask1 = 0xFF00FF;
        int mask2 = -16711936;
        int f2 = (int)(256.0 * ratio);
        int f1 = 256 - f2;
        return (a & mask1) * f1 + (b & mask1) * f2 >> 8 & mask1 | (a & mask2) * f1 + (b & mask2) * f2 >> 8 & mask2;
    }

    private static BiomeSpecialEffects.GrassColorModifier make(String name, BiomeSpecialEffects.GrassColorModifier.ColorModifier delegate) {
        name = TwilightForestMod.prefix(name).toString();
        return BiomeSpecialEffects.GrassColorModifier.create((String)name, (String)name, (BiomeSpecialEffects.GrassColorModifier.ColorModifier)delegate);
    }
}

