/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.dispenser;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public class SkullCandleDispenseBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
        ServerLevel level = source.m_7727_();
        if (!level.m_5776_()) {
            BlockPos blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            this.m_123573_(SkullCandleDispenseBehavior.tryAddCandle(level, blockpos, stack.m_41720_()) || SkullCandleDispenseBehavior.tryCreateSkullCandle(level, blockpos, stack.m_41720_()));
            if (this.m_123570_()) {
                stack.m_41774_(1);
            }
        }
        return stack;
    }

    private static boolean tryAddCandle(ServerLevel level, BlockPos pos, Item candle) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (candle == AbstractSkullCandleBlock.candleColorToCandle(AbstractSkullCandleBlock.CandleColors.colorFromInt(sc.candleColor).m_7912_()).m_5456_() && sc.candleAmount < 4) {
                ++sc.candleAmount;
                level.m_5594_(null, pos, SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5518_().m_142202_(pos);
                level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 1);
                return true;
            }
        }
        return false;
    }

    private static boolean tryCreateSkullCandle(ServerLevel level, BlockPos pos, Item candle) {
        BlockState blockstate = level.m_8055_(pos);
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractSkullBlock) {
            AbstractSkullBlock skull = (AbstractSkullBlock)block;
            SkullBlock.Types type = (SkullBlock.Types)skull.m_48754_();
            boolean wall = blockstate.m_60734_() instanceof WallSkullBlock;
            switch (type) {
                case SKELETON: {
                    if (wall) {
                        SkullCandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.SKELETON_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    SkullCandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.SKELETON_SKULL_CANDLE.get(), candle);
                    break;
                }
                case WITHER_SKELETON: {
                    if (wall) {
                        SkullCandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    SkullCandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get(), candle);
                    break;
                }
                case PLAYER: {
                    if (wall) {
                        SkullCandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.PLAYER_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    SkullCandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.PLAYER_SKULL_CANDLE.get(), candle);
                    break;
                }
                case ZOMBIE: {
                    if (wall) {
                        SkullCandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    SkullCandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.ZOMBIE_SKULL_CANDLE.get(), candle);
                    break;
                }
                case CREEPER: {
                    if (wall) {
                        SkullCandleDispenseBehavior.makeWallSkull((Level)level, pos, (Block)TFBlocks.CREEPER_WALL_SKULL_CANDLE.get(), candle);
                        break;
                    }
                    SkullCandleDispenseBehavior.makeFloorSkull((Level)level, pos, (Block)TFBlocks.CREEPER_SKULL_CANDLE.get(), candle);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static void makeFloorSkull(Level level, BlockPos pos, Block newBlock, Item candle) {
        GameProfile profile = null;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.m_59779_();
        }
        level.m_46597_(pos, (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)SkullCandleBlock.ROTATION, (Comparable)((Integer)level.m_8055_(pos).m_61143_((Property)SkullBlock.f_56314_))));
        level.m_151523_((BlockEntity)new SkullCandleBlockEntity(pos, (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)SkullCandleBlock.ROTATION, (Comparable)((Integer)level.m_8055_(pos).m_61143_((Property)SkullBlock.f_56314_))), AbstractSkullCandleBlock.candleToCandleColor(candle).getValue(), 1));
        blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.m_59769_(profile);
        }
    }

    private static void makeWallSkull(Level level, BlockPos pos, Block newBlock, Item candle) {
        GameProfile profile = null;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.m_59779_();
        }
        level.m_46597_(pos, (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)WallSkullCandleBlock.FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)WallSkullBlock.f_58097_))));
        level.m_151523_((BlockEntity)new SkullCandleBlockEntity(pos, (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)WallSkullCandleBlock.FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)WallSkullBlock.f_58097_))), AbstractSkullCandleBlock.candleToCandleColor(candle).getValue(), 1));
        blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.m_59769_(profile);
        }
    }
}

