/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat;

import blusunrize.immersiveengineering.api.crafting.builders.ThermoelectricSourceBuilder;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.EventHandler;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.compat.TFCompat;
import twilightforest.compat.ie.IEShaderRegister;
import twilightforest.compat.ie.ShaderBagItemModel;
import twilightforest.compat.ie.TFShaderGrabbagItem;
import twilightforest.compat.ie.TFShaderItem;
import twilightforest.entity.boss.AlphaYeti;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.boss.Minoshroom;
import twilightforest.entity.boss.Naga;
import twilightforest.entity.boss.PlateauBoss;
import twilightforest.entity.boss.SnowQueen;
import twilightforest.entity.boss.UrGhast;
import twilightforest.entity.projectile.CicadaShot;

public class IECompat
extends TFCompat {
    public IECompat() {
        super("Immersive Engineering");
    }

    @Override
    protected void initItems(RegistryEvent.Register<Item> evt) {
        IForgeRegistry r = evt.getRegistry();
        r.register((IForgeRegistryEntry)((Item)new TFShaderItem().setRegistryName(TwilightForestMod.prefix("shader"))));
        for (Rarity rarity : ShaderRegistry.rarityWeightMap.keySet()) {
            r.register((IForgeRegistryEntry)new TFShaderGrabbagItem(rarity));
        }
    }

    @Override
    protected boolean preInit() {
        ShaderRegistry.rarityWeightMap.put(TwilightForestMod.getRarity(), 1);
        return true;
    }

    @Override
    protected void init(FMLCommonSetupEvent event) {
        RailgunHandler.registerProjectile(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)TFBlocks.CICADA.get()).m_5456_()}), (RailgunHandler.IRailgunProjectile)new RailgunHandler.StandardRailgunProjectile(2.0, 0.25){

            public Entity getProjectile(@Nullable Player shooter, ItemStack ammo, Entity projectile) {
                Vec3 look = shooter.m_20154_();
                shooter.f_19853_.m_5594_(null, shooter.m_142538_(), TFSounds.CICADA_FLYING, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return new CicadaShot(shooter.f_19853_, (LivingEntity)shooter, look.f_82479_ * 20.0, look.f_82480_ * 20.0, look.f_82481_ * 20.0);
            }

            public boolean isValidForTurret() {
                return false;
            }
        });
        ThermoelectricSourceBuilder.builder((Block)((Block)TFBlocks.FIERY_BLOCK.get())).kelvin(2500);
        IEShaderRegister.initShaders();
        EventHandler.listOfBoringBosses.add(Naga.class);
        EventHandler.listOfBoringBosses.add(Lich.class);
        EventHandler.listOfBoringBosses.add(Minoshroom.class);
        EventHandler.listOfBoringBosses.add(Hydra.class);
        EventHandler.listOfBoringBosses.add(KnightPhantom.class);
        EventHandler.listOfBoringBosses.add(UrGhast.class);
        EventHandler.listOfBoringBosses.add(AlphaYeti.class);
        EventHandler.listOfBoringBosses.add(SnowQueen.class);
        EventHandler.listOfBoringBosses.add(PlateauBoss.class);
    }

    private void excludeFromShaderBags(Class<? extends Entity> entityClass) {
        InterModComms.sendTo((String)"immersiveengineering", (String)"shaderbag_exclude", entityClass::getName);
    }

    @Override
    protected void postInit() {
    }

    @Override
    protected void handleIMCs() {
        this.excludeFromShaderBags(Naga.class);
        this.excludeFromShaderBags(Lich.class);
        this.excludeFromShaderBags(Minoshroom.class);
        this.excludeFromShaderBags(Hydra.class);
        this.excludeFromShaderBags(KnightPhantom.class);
        this.excludeFromShaderBags(UrGhast.class);
        this.excludeFromShaderBags(AlphaYeti.class);
        this.excludeFromShaderBags(SnowQueen.class);
        this.excludeFromShaderBags(PlateauBoss.class);
    }

    public static void registerShaderColors(ItemColors colors) {
        colors.m_92689_(TFShaderItem::getShaderColors, new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(TwilightForestMod.prefix("shader"))});
        for (Rarity r : ShaderRegistry.rarityWeightMap.keySet()) {
            colors.m_92689_((stack, tintIndex) -> {
                int c = r.f_43022_.m_126665_();
                float d = tintIndex + 1;
                return (int)((float)(c >> 16 & 0xFF) / d) << 16 | (int)((float)(c >> 8 & 0xFF) / d) << 8 | (int)((float)(c & 0xFF) / d);
            }, new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(TwilightForestMod.prefix("shader_bag_" + r.name().toLowerCase(Locale.ROOT).replace(':', '_')))});
        }
    }

    public static void registerShaderModels(ModelBakeEvent event) {
        for (Rarity rarity : ShaderRegistry.rarityWeightMap.keySet()) {
            ResourceLocation itemRL = TwilightForestMod.prefix("shader_bag_" + rarity.name().toLowerCase(Locale.ROOT).replace(':', '_'));
            ModelResourceLocation mrl = new ModelResourceLocation(itemRL, "inventory");
            event.getModelRegistry().put(mrl, new ShaderBagItemModel((BakedModel)event.getModelRegistry().get(mrl), new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemRL))));
        }
    }
}

