/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.client.TFClientEvents;

@OnlyIn(value=Dist.CLIENT)
public class LoadingScreenGui
extends Screen {
    private boolean isEntering;
    private boolean contentNeedsAssignment = false;
    private long ticks = 0L;
    private long seed;
    private BackgroundThemes backgroundTheme;
    private ItemStack item;
    private static final Random random = new Random();
    private static final float backgroundScale = 32.0f;
    private static final TFConfig.Client.LoadingScreen LOADING_SCREEN = TFConfig.CLIENT_CONFIG.LOADING_SCREEN;

    LoadingScreenGui() {
        super(NarratorChatListener.f_93310_);
    }

    void setEntering(boolean isEntering) {
        this.isEntering = isEntering;
    }

    protected void m_7856_() {
        this.f_169369_.clear();
        this.assignContent();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_96624_() {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (Integer)LoadingScreenGui.LOADING_SCREEN.cycleLoadingScreenFrequency.get() != 0 && ++this.ticks % (long)((Integer)LoadingScreenGui.LOADING_SCREEN.cycleLoadingScreenFrequency.get()).intValue() == 0L) {
            this.assignContent();
        }
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            boolean flag1;
            BlockPos blockpos = this.f_96541_.f_91074_.m_142538_();
            boolean bl = flag1 = this.f_96541_.f_91073_ != null && this.f_96541_.f_91073_.m_151562_(blockpos.m_123342_());
            if (flag1 || this.f_96541_.f_91060_.m_202430_(blockpos)) {
                this.m_7379_();
            }
        }
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.contentNeedsAssignment) {
            this.assignContent();
            this.contentNeedsAssignment = false;
        }
        Font fontRenderer = this.f_96541_.f_91062_;
        Window resolution = this.f_96541_.m_91268_();
        this.drawBackground(resolution.m_85445_(), resolution.m_85446_());
        PoseStack stack = RenderSystem.m_157191_();
        RenderSystem.m_157182_();
        this.drawBouncingWobblyItem(stack, partialTicks, resolution.m_85445_(), resolution.m_85446_());
        RenderSystem.m_157182_();
        String loadTitle = I18n.m_118938_((String)("twilightforest.loading.title." + (this.isEntering ? "enter" : "leave")), (Object[])new Object[0]);
        ms.m_85836_();
        ms.m_85837_((double)((float)resolution.m_85445_() / 2.0f - (float)fontRenderer.m_92895_(loadTitle) / 4.0f), (double)((float)resolution.m_85446_() / 3.0f), 0.0);
        ms.m_85837_((double)(-((float)fontRenderer.m_92895_(loadTitle) / 4.0f)), 0.0, 0.0);
        fontRenderer.m_92750_(ms, loadTitle, 0.0f, 0.0f, 0xEEEEEE);
        ms.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void assignContent() {
        this.backgroundTheme = BackgroundThemes.values()[random.nextInt(BackgroundThemes.values().length)];
        this.item = (ItemStack)LOADING_SCREEN.getLoadingScreenIcons().get(random.nextInt(LOADING_SCREEN.getLoadingScreenIcons().size()));
        this.seed = random.nextLong();
    }

    private void drawBackground(float width, float height) {
        random.setSeed(this.seed);
        this.backgroundTheme.renderBackground(width, height);
        this.backgroundTheme.postRenderBackground(width, height);
    }

    private void drawBouncingWobblyItem(PoseStack stack, float partialTicks, float width, float height) {
        float sineTicker = (TFClientEvents.sineTicker + partialTicks) * ((Double)LoadingScreenGui.LOADING_SCREEN.frequency.get()).floatValue();
        float sineTicker2 = (TFClientEvents.sineTicker + 314.0f + partialTicks) * ((Double)LoadingScreenGui.LOADING_SCREEN.frequency.get()).floatValue();
        stack.m_85836_();
        stack.m_85837_((double)(width - width / 30.0f * ((Double)LoadingScreenGui.LOADING_SCREEN.scale.get()).floatValue()), (double)(height - height / 10.0f), 0.0);
        if (((Boolean)LoadingScreenGui.LOADING_SCREEN.enable.get()).booleanValue()) {
            stack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)(sineTicker / ((Double)LoadingScreenGui.LOADING_SCREEN.tiltRange.get()).floatValue())) * ((Double)LoadingScreenGui.LOADING_SCREEN.tiltConstant.get()).floatValue()));
            stack.m_85841_((Mth.m_14031_((float)((sineTicker2 + 180.0f) / ((Double)LoadingScreenGui.LOADING_SCREEN.tiltRange.get()).floatValue() * 2.0f)) / ((Double)LoadingScreenGui.LOADING_SCREEN.scaleDeviation.get()).floatValue() + 2.0f) * (((Double)LoadingScreenGui.LOADING_SCREEN.scale.get()).floatValue() / 2.0f), (Mth.m_14031_((float)((sineTicker + 180.0f) / ((Double)LoadingScreenGui.LOADING_SCREEN.tiltRange.get()).floatValue() * 2.0f)) / ((Double)LoadingScreenGui.LOADING_SCREEN.scaleDeviation.get()).floatValue() + 2.0f) * (((Double)LoadingScreenGui.LOADING_SCREEN.scale.get()).floatValue() / 2.0f), 1.0f);
        }
        stack.m_85837_(-8.0, -16.5, 0.0);
        this.f_96541_.m_91291_().m_115203_(this.item, 0, 0);
        stack.m_85849_();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BackgroundThemes {
        LABYRINTH(new ResourceLocation[]{TwilightForestMod.prefix("textures/block/mazestone_brick.png"), TwilightForestMod.prefix("textures/block/mazestone_brick.png"), TwilightForestMod.prefix("textures/block/cracked_mazestone.png")}){
            private final ResourceLocation mazestoneDecor = TwilightForestMod.prefix("textures/block/decorative_mazestone.png");

            @Override
            void postRenderBackground(float width, float height) {
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder buffer = tessellator.m_85915_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.mazestoneDecor);
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                buffer.m_5483_(0.0, 24.0, 0.0).m_7421_(0.0f, 0.75f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, 24.0, 0.0).m_7421_(width / 32.0f, 0.75f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, 8.0, 0.0).m_7421_(width / 32.0f, 0.25f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_(0.0, 8.0, 0.0).m_7421_(0.0f, 0.25f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                tessellator.m_85914_();
                float halfScale = 16.0f;
                float bottomGrid = height - height % halfScale;
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                buffer.m_5483_(0.0, (double)bottomGrid, 0.0).m_7421_(0.0f, 0.75f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, (double)bottomGrid, 0.0).m_7421_(width / 32.0f, 0.75f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, (double)(bottomGrid - halfScale), 0.0).m_7421_(width / 32.0f, 0.25f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_(0.0, (double)(bottomGrid - halfScale), 0.0).m_7421_(0.0f, 0.25f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                tessellator.m_85914_();
            }
        }
        ,
        STRONGHOLD(TwilightForestMod.prefix("textures/block/underbrick.png"), TwilightForestMod.prefix("textures/block/mossy_underbrick.png"), TwilightForestMod.prefix("textures/block/cracked_underbrick.png")),
        DARKTOWER(new ResourceLocation[]{TwilightForestMod.prefix("textures/block/towerwood.png"), TwilightForestMod.prefix("textures/block/towerwood.png"), TwilightForestMod.prefix("textures/block/mossy_towerwood.png"), TwilightForestMod.prefix("textures/block/cracked_towerwood.png"), TwilightForestMod.prefix("textures/block/cracked_towerwood_alt.png")}){
            private final ResourceLocation towerwoodEncased = TwilightForestMod.prefix("textures/block/encased_towerwood.png");
            private final float stretch = 0.985f;
            private final float depth = 1.15f;

            @Override
            void renderBackground(float width, float height) {
                float headerDepthHeight = 37.360405f;
                float footerDepthHeight = height - 37.360405f;
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder buffer = tessellator.m_85915_();
                RenderSystem.m_157429_((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
                for (float x = 32.0f; x < width + 32.0f; x += 32.0f) {
                    for (float y = 69.360405f; y < footerDepthHeight + 32.0f; y += 32.0f) {
                        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackgroundMaterials()[random.nextInt(this.getBackgroundMaterials().length)]);
                        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                        buffer.m_5483_((double)(x - 32.0f), (double)y, 0.0).m_7421_(0.0f, 1.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(1.0f, 1.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                        buffer.m_5483_((double)x, (double)(y - 32.0f), 0.0).m_7421_(1.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                        buffer.m_5483_((double)(x - 32.0f), (double)(y - 32.0f), 0.0).m_7421_(0.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                        tessellator.m_85914_();
                    }
                }
            }

            @Override
            void postRenderBackground(float width, float height) {
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder buffer = tessellator.m_85915_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.towerwoodEncased);
                float offset = 0.4f;
                float textureHeaderXMin = 0.985f * offset;
                float textureHeaderXMax = width / 32.0f * 0.985f + offset;
                float headerBottom = 32.48731f;
                float headerDepthHeight = 37.360405f;
                float footerTop = height - 32.48731f;
                float footerDepthHeight = height - 37.360405f;
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                buffer.m_5483_(0.0, (double)32.48731f, 0.0).m_7421_(textureHeaderXMin, 1.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, (double)32.48731f, 0.0).m_7421_(textureHeaderXMax, 1.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, 0.0, 0.0).m_7421_(textureHeaderXMax, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_(0.0, 0.0, 0.0).m_7421_(textureHeaderXMin, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                tessellator.m_85914_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                buffer.m_5483_(0.0, 37.36040496826172, 0.0).m_7421_(0.0f, 1.0f).m_85950_(0.25f, 0.25f, 0.25f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, 37.36040496826172, 0.0).m_7421_(width / 32.0f, 1.0f).m_85950_(0.25f, 0.25f, 0.25f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, (double)32.48731f, 0.0).m_7421_(textureHeaderXMax, 0.0f).m_85950_(0.25f, 0.25f, 0.25f, 1.0f).m_5752_();
                buffer.m_5483_(0.0, (double)32.48731f, 0.0).m_7421_(textureHeaderXMin, 0.0f).m_85950_(0.25f, 0.25f, 0.25f, 1.0f).m_5752_();
                tessellator.m_85914_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                buffer.m_5483_(0.0, (double)height, 0.0).m_7421_(textureHeaderXMin, 1.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, (double)height, 0.0).m_7421_(textureHeaderXMax, 1.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, (double)footerTop, 0.0).m_7421_(textureHeaderXMax, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                buffer.m_5483_(0.0, (double)footerTop, 0.0).m_7421_(textureHeaderXMin, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                tessellator.m_85914_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                buffer.m_5483_(0.0, (double)footerTop, 0.0).m_7421_(textureHeaderXMin, 1.0f).m_85950_(0.75f, 0.75f, 0.75f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, (double)footerTop, 0.0).m_7421_(textureHeaderXMax, 1.0f).m_85950_(0.75f, 0.75f, 0.75f, 1.0f).m_5752_();
                buffer.m_5483_((double)width, (double)footerDepthHeight, 0.0).m_7421_(width / 32.0f, 0.0f).m_85950_(0.75f, 0.75f, 0.75f, 1.0f).m_5752_();
                buffer.m_5483_(0.0, (double)footerDepthHeight, 0.0).m_7421_(0.0f, 0.0f).m_85950_(0.75f, 0.75f, 0.75f, 1.0f).m_5752_();
                tessellator.m_85914_();
            }
        }
        ,
        FINALCASTLE(new ResourceLocation[]{TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/cracked_castle_brick.png"), TwilightForestMod.prefix("textures/block/worn_castle_brick.png")}){
            private final ResourceLocation[] magic = new ResourceLocation[]{TwilightForestMod.prefix("textures/block/castleblock_magic_0.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_1.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_2.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_3.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_4.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_5.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_6.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_7.png")};
            private final int[] colors = new int[]{0xFF00FF, 65535, 0xFFFF00, 4915330};

            @Override
            void postRenderBackground(float width, float height) {
                float x;
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder buffer = tessellator.m_85915_();
                int color = this.colors[random.nextInt(this.colors.length)];
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                for (x = 32.0f; x < width + 32.0f; x += 32.0f) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)this.magic[random.nextInt(this.magic.length)]);
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    buffer.m_5483_((double)(x - 32.0f), 48.0, 0.0).m_7421_(0.0f, 1.0f).m_6122_(r, g, b, 255).m_5752_();
                    buffer.m_5483_((double)x, 48.0, 0.0).m_7421_(1.0f, 1.0f).m_6122_(r, g, b, 255).m_5752_();
                    buffer.m_5483_((double)x, 16.0, 0.0).m_7421_(1.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
                    buffer.m_5483_((double)(x - 32.0f), 16.0, 0.0).m_7421_(0.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
                    tessellator.m_85914_();
                }
                for (x = 32.0f; x < width + 32.0f; x += 32.0f) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)this.magic[random.nextInt(this.magic.length)]);
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    buffer.m_5483_((double)(x - 32.0f), (double)(height - 16.0f), 0.0).m_7421_(0.0f, 1.0f).m_6122_(r, g, b, 255).m_5752_();
                    buffer.m_5483_((double)x, (double)(height - 16.0f), 0.0).m_7421_(1.0f, 1.0f).m_6122_(r, g, b, 255).m_5752_();
                    buffer.m_5483_((double)x, (double)(height - 32.0f - 16.0f), 0.0).m_7421_(1.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
                    buffer.m_5483_((double)(x - 32.0f), (double)(height - 32.0f - 16.0f), 0.0).m_7421_(0.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
                    tessellator.m_85914_();
                }
            }
        };

        private final ResourceLocation[] backgroundMaterials;

        private BackgroundThemes(ResourceLocation ... backgroundMaterials) {
            this.backgroundMaterials = backgroundMaterials;
        }

        ResourceLocation[] getBackgroundMaterials() {
            return this.backgroundMaterials;
        }

        void renderBackground(float width, float height) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            RenderSystem.m_157429_((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
            for (float x = 32.0f; x < width + 32.0f; x += 32.0f) {
                for (float y = 32.0f; y < height + 32.0f; y += 32.0f) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackgroundMaterials()[random.nextInt(this.getBackgroundMaterials().length)]);
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    buffer.m_5483_((double)(x - 32.0f), (double)y, 0.0).m_7421_(0.0f, 1.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                    buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(1.0f, 1.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                    buffer.m_5483_((double)x, (double)(y - 32.0f), 0.0).m_7421_(1.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                    buffer.m_5483_((double)(x - 32.0f), (double)(y - 32.0f), 0.0).m_7421_(0.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
                    tessellator.m_85914_();
                }
            }
        }

        void postRenderBackground(float width, float height) {
        }
    }
}

