/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.TFSounds;
import twilightforest.block.SpecialMagicLogBlock;
import twilightforest.network.ChangeBiomePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.WorldUtil;
import twilightforest.world.registration.biomes.BiomeKeys;

public class TransLogCoreBlock
extends SpecialMagicLogBlock {
    public TransLogCoreBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    void performTreeEffect(Level world, BlockPos pos, Random rand) {
        ResourceKey<Biome> target = BiomeKeys.ENCHANTED_FOREST;
        Holder biome = world.m_5962_().m_206191_(Registry.f_122885_).m_206081_(target);
        for (int i = 0; i < 16; ++i) {
            BlockPos dPos = WorldUtil.randomOffset(rand, pos, 16, 0, 16);
            if (dPos.m_123331_((Vec3i)pos) > 256.0 || world.m_204166_(dPos).m_203565_(target)) continue;
            int minY = QuartPos.m_175400_((int)world.m_141937_());
            int maxY = minY + QuartPos.m_175400_((int)world.m_141928_()) - 1;
            int x = QuartPos.m_175400_((int)dPos.m_123341_());
            int z = QuartPos.m_175400_((int)dPos.m_123343_());
            LevelChunk chunkAt = world.m_6325_(dPos.m_123341_() >> 4, dPos.m_123343_() >> 4);
            for (LevelChunkSection section : chunkAt.m_7103_()) {
                for (int dy = minY; dy < maxY; ++dy) {
                    int y = Mth.m_14045_((int)QuartPos.m_175400_((int)dy), (int)minY, (int)maxY);
                    if (((Holder)section.m_188013_().m_63087_(x & 3, y & 3, z & 3)).m_203565_(target)) continue;
                    section.m_188013_().m_156470_(x & 3, y & 3, z & 3, (Object)biome);
                }
            }
            if (!(world instanceof ServerLevel)) break;
            this.sendChangedBiome(chunkAt, dPos, target);
            break;
        }
    }

    private void sendChangedBiome(LevelChunk chunk, BlockPos pos, ResourceKey<Biome> biome) {
        ChangeBiomePacket message = new ChangeBiomePacket(pos, biome);
        TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)message);
    }

    @Override
    protected void playSound(Level level, BlockPos pos, Random rand) {
        level.m_5594_(null, pos, TFSounds.TRANSFORMATION_CORE, SoundSource.BLOCKS, 0.1f, rand.nextFloat() * 2.0f);
    }
}

