/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity.dispenser;

import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CuttingBoardDispenseBehavior
extends OptionalDispenseItemBehavior {
    private static final HashMap<Item, DispenseItemBehavior> DISPENSE_ITEM_BEHAVIOR_HASH_MAP = new HashMap();

    public static void registerBehaviour(Item item, CuttingBoardDispenseBehavior behavior) {
        DISPENSE_ITEM_BEHAVIOR_HASH_MAP.put(item, (DispenseItemBehavior)DispenserBlock.f_52661_.get(item));
        DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)behavior);
    }

    public final ItemStack m_6115_(BlockSource source, ItemStack stack) {
        if (this.tryDispenseStackOnCuttingBoard(source, stack)) {
            this.m_6823_(source);
            this.m_123387_(source, (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            return stack;
        }
        return DISPENSE_ITEM_BEHAVIOR_HASH_MAP.get(stack.m_41720_()).m_6115_(source, stack);
    }

    public boolean tryDispenseStackOnCuttingBoard(BlockSource source, ItemStack stack) {
        this.m_123573_(false);
        ServerLevel world = source.m_7727_();
        BlockPos blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        BlockState blockstate = world.m_8055_(blockpos);
        Block block = blockstate.m_60734_();
        BlockEntity te = world.m_7702_(blockpos);
        if (block instanceof CuttingBoardBlock && te instanceof CuttingBoardBlockEntity) {
            CuttingBoardBlockEntity tileEntity = (CuttingBoardBlockEntity)te;
            ItemStack boardItem = tileEntity.getStoredItem().m_41777_();
            if (!boardItem.m_41619_() && tileEntity.processStoredItemUsingTool(stack, null)) {
                CuttingBoardBlock.spawnCuttingParticles((Level)world, blockpos, boardItem, 5);
                this.m_123573_(true);
            }
            return true;
        }
        return false;
    }
}

