/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common;

import java.util.Arrays;
import java.util.Collections;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.block.entity.dispenser.CuttingBoardDispenseBehavior;
import vectorwing.farmersdelight.common.crafting.condition.VanillaCrateEnabledCondition;
import vectorwing.farmersdelight.common.entity.RottenTomatoEntity;
import vectorwing.farmersdelight.common.loot.function.CopyMealFunction;
import vectorwing.farmersdelight.common.loot.function.CopySkilletFunction;
import vectorwing.farmersdelight.common.loot.function.SmokerCookFunction;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.world.WildCropGeneration;

public class CommonSetup {
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CommonSetup.registerCompostables();
            CommonSetup.registerDispenserBehaviors();
            CommonSetup.registerAnimalFeeds();
            WildCropGeneration.registerWildCropGeneration();
        });
        ModAdvancements.register();
        LootItemFunctions.m_80762_((String)CopyMealFunction.ID.toString(), (Serializer)new CopyMealFunction.Serializer());
        LootItemFunctions.m_80762_((String)CopySkilletFunction.ID.toString(), (Serializer)new CopySkilletFunction.Serializer());
        LootItemFunctions.m_80762_((String)SmokerCookFunction.ID.toString(), (Serializer)new SmokerCookFunction.Serializer());
        CraftingHelper.register((IConditionSerializer)new VanillaCrateEnabledCondition.Serializer());
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.ROTTEN_TOMATO.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level pLevel, Position pPosition, ItemStack pStack) {
                return new RottenTomatoEntity(pLevel, pPosition.m_7096_(), pPosition.m_7098_(), pPosition.m_7094_());
            }
        });
        if (((Boolean)Configuration.DISPENSER_TOOLS_CUTTING_BOARD.get()).booleanValue()) {
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42422_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42423_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42421_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42427_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42428_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42426_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42385_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42386_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42384_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42390_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42391_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42389_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42432_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42433_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42431_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42395_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42396_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42394_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.f_42574_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.FLINT_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.IRON_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.DIAMOND_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.GOLDEN_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.NETHERITE_KNIFE.get(), new CuttingBoardDispenseBehavior());
        }
    }

    public static void registerCompostables() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TREE_BARK.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.STRAW.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CABBAGE_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TOMATO_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RICE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RICE_PANICLE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PUMPKIN_SLICE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CABBAGE_LEAF.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CABBAGE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.ONION.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TOMATO.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_CABBAGES.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_ONIONS.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_TOMATOES.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_CARROTS.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_POTATOES.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_BEETROOTS.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_RICE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.PIE_CRUST.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RICE_BALE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SWEET_BERRY_COOKIE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.HONEY_COOKIE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CAKE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.APPLE_PIE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SWEET_BERRY_CHEESECAKE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CHOCOLATE_PIE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RAW_PASTA.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.ROTTEN_TOMATO.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.APPLE_PIE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SWEET_BERRY_CHEESECAKE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CHOCOLATE_PIE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.DUMPLINGS.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.STUFFED_PUMPKIN.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BROWN_MUSHROOM_COLONY.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RED_MUSHROOM_COLONY.get()), 1.0f);
    }

    public static void registerAnimalFeeds() {
        Ingredient newChickenFood = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE_SEEDS.get(), (ItemLike)ModItems.TOMATO_SEEDS.get(), (ItemLike)ModItems.RICE.get()});
        Chicken.f_28233_ = new CompoundIngredient(Arrays.asList(Chicken.f_28233_, newChickenFood)){};
        Ingredient newPigFood = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE.get(), (ItemLike)ModItems.TOMATO.get()});
        Pig.f_29458_ = new CompoundIngredient(Arrays.asList(Pig.f_29458_, newPigFood)){};
        Collections.addAll(Parrot.f_29357_, (Item)ModItems.CABBAGE_SEEDS.get(), (Item)ModItems.TOMATO_SEEDS.get(), (Item)ModItems.RICE.get());
    }
}

