/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings;

import ht.treechop.TreeChopMod;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class ChopSettings {
    private EnumMap<SettingsField, Object> fieldValues = new EnumMap(SettingsField.class);

    public ChopSettings() {
        for (SettingsField field : SettingsField.values()) {
            this.fieldValues.put(field, field.getDefaultValue());
        }
    }

    public boolean getChoppingEnabled() {
        return this.get(SettingsField.CHOPPING, Boolean.class);
    }

    public boolean getFellingEnabled() {
        return this.get(SettingsField.FELLING, Boolean.class);
    }

    public SneakBehavior getSneakBehavior() {
        return this.get(SettingsField.SNEAK_BEHAVIOR, SneakBehavior.class);
    }

    public boolean getTreesMustHaveLeaves() {
        return this.get(SettingsField.TREES_MUST_HAVE_LEAVES, Boolean.class);
    }

    public boolean getChopInCreativeMode() {
        return this.get(SettingsField.CHOP_IN_CREATIVE_MODE, Boolean.class);
    }

    public void setChoppingEnabled(boolean enabled) {
        this.set(SettingsField.CHOPPING, enabled);
    }

    public void setFellingEnabled(boolean enabled) {
        this.set(SettingsField.FELLING, enabled);
    }

    public void setSneakBehavior(SneakBehavior behavior) {
        this.set(SettingsField.SNEAK_BEHAVIOR, (Object)behavior);
    }

    public void setTreesMustHaveLeaves(boolean enabled) {
        this.set(SettingsField.TREES_MUST_HAVE_LEAVES, enabled);
    }

    public void setChopInCreativeMode(boolean enabled) {
        this.set(SettingsField.CHOP_IN_CREATIVE_MODE, enabled);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ChopSettings) {
            ChopSettings otherSettings = (ChopSettings)other;
            return Arrays.stream(SettingsField.VALUES).allMatch(field -> this.get((SettingsField)((Object)field)).equals(otherSettings.get((SettingsField)((Object)field))));
        }
        return false;
    }

    public void copyFrom(ChopSettings other) {
        this.fieldValues.putAll(other.fieldValues);
    }

    public <T> T get(SettingsField field, Class<T> type) {
        Object value = this.fieldValues.get((Object)field);
        if (!type.isInstance(value)) {
            value = field.getDefaultValue();
            this.fieldValues.put(field, value);
        }
        return type.cast(value);
    }

    public Object get(SettingsField field) {
        return this.fieldValues.get((Object)field);
    }

    public void forEachSetting(BiConsumer<SettingsField, Object> consumer) {
        this.fieldValues.forEach(consumer);
    }

    public void set(SettingsField field, Object value) {
        if (field.getDefaultValue().getClass().isInstance(value)) {
            this.fieldValues.put(field, value);
        } else {
            TreeChopMod.LOGGER.warn(String.format("Refusing to set setting %s to illegal value %s (%s)", new Object[]{field, value, value.getClass()}));
        }
    }

    public void set(Pair<SettingsField, Object> fieldValuePair) {
        this.set((SettingsField)((Object)fieldValuePair.getLeft()), fieldValuePair.getRight());
    }

    public void set(Setting setting) {
        this.set(setting.getField(), setting.getValue());
    }

    public List<Setting> getAll() {
        return Arrays.stream(SettingsField.values()).map(field -> new Setting((SettingsField)((Object)field), this.get((SettingsField)((Object)field)))).collect(Collectors.toList());
    }

    public Setting getSetting(SettingsField field) {
        return new Setting(field, this.get(field));
    }
}

