/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.variants.IIslandVariant;
import slimeknights.tconstruct.world.worldgen.islands.variants.IslandVariants;

public class SlimeIslandPiece
extends TemplateStructurePiece {
    @Nullable
    private final ConfiguredFeature<?, ?> tree;
    private final IIslandVariant variant;
    private int numberOfTreesPlaced;
    private ChunkGenerator chunkGenerator;

    private SlimeIslandPiece(StructureManager manager, IIslandVariant variant, ResourceLocation templateName, BlockPos templatePos, @Nullable ConfiguredFeature<?, ?> tree, Rotation rotation, Mirror mirror) {
        super((StructurePieceType)TinkerStructures.slimeIslandPiece.get(), 0, manager, templateName, templateName.toString(), SlimeIslandPiece.makeSettings(rotation, mirror), templatePos);
        this.variant = variant;
        this.numberOfTreesPlaced = 0;
        this.tree = tree;
    }

    public SlimeIslandPiece(StructureManager manager, IIslandVariant variant, String templateName, BlockPos templatePos, @Nullable ConfiguredFeature<?, ?> tree, Rotation rotation, Mirror mirror) {
        this(manager, variant, variant.getStructureName(templateName), templatePos, tree, rotation, mirror);
    }

    public SlimeIslandPiece(StructureManager templateManager, CompoundTag nbt) {
        super((StructurePieceType)TinkerStructures.slimeIslandPiece.get(), nbt, templateManager, context -> SlimeIslandPiece.makeSettings(Rotation.valueOf((String)nbt.m_128461_("Rot")), Mirror.valueOf((String)nbt.m_128461_("Mi"))));
        this.variant = IslandVariants.getVariantFromIndex(nbt.m_128451_("Variant"));
        this.numberOfTreesPlaced = nbt.m_128451_("NumberOfTreesPlaced");
        this.tree = Optional.of(nbt.m_128461_("Tree")).filter(s -> !s.isEmpty()).map(ResourceLocation::m_135820_).flatMap(arg_0 -> ((Registry)BuiltinRegistries.f_123861_).m_6612_(arg_0)).orElse(null);
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation, Mirror mirror) {
        return new StructurePlaceSettings().m_74392_(true).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_).m_74379_(rotation).m_74377_(mirror);
    }

    protected void m_183620_(StructurePieceSerializationContext pContext, CompoundTag tag) {
        ResourceLocation key;
        super.m_183620_(pContext, tag);
        tag.m_128405_("Variant", this.variant.getIndex());
        tag.m_128359_("Rot", this.f_73657_.m_74404_().name());
        tag.m_128359_("Mi", this.f_73657_.m_74401_().name());
        tag.m_128405_("NumberOfTreesPlaced", this.numberOfTreesPlaced);
        if (this.tree != null && (key = BuiltinRegistries.f_123861_.m_7981_(this.tree)) != null) {
            tag.m_128359_("Tree", key.toString());
        }
    }

    protected void m_7756_(String function, BlockPos pos, ServerLevelAccessor level, Random rand, BoundingBox sbb) {
        switch (function) {
            case "tconstruct:lake_bottom": {
                level.m_7731_(pos, this.variant.getLakeBottom(), 2);
                break;
            }
            case "tconstruct:slime_fluid": {
                level.m_7731_(pos, this.variant.getLakeFluid(), 2);
                break;
            }
            case "tconstruct:congealed_slime": {
                level.m_7731_(pos, this.variant.getCongealedSlime(rand), 2);
                break;
            }
            case "tconstruct:slime_vine": {
                BlockState vines = this.variant.getVines();
                if (vines == null || !rand.nextBoolean()) break;
                SlimeIslandPiece.placeVine((LevelAccessor)level, pos, rand, vines);
                break;
            }
            case "tconstruct:slime_tree": {
                WorldGenLevel worldgenLevel;
                if (this.tree == null || this.numberOfTreesPlaced >= 3 || !rand.nextBoolean() || !(level instanceof WorldGenLevel) || !this.tree.m_65385_(worldgenLevel = (WorldGenLevel)level, this.chunkGenerator, rand, pos)) break;
                ++this.numberOfTreesPlaced;
                break;
            }
            case "tconstruct:slime_tall_grass": {
                BushBlock bush;
                Block block;
                BlockState state;
                if (!rand.nextBoolean() || (state = this.variant.getPlant(rand)) == null || !((block = state.m_60734_()) instanceof BushBlock) || !(bush = (BushBlock)block).m_7898_(state, (LevelReader)level, pos)) break;
                level.m_7731_(pos, state, 2);
            }
        }
    }

    private static void placeVine(LevelAccessor worldIn, BlockPos pos, Random random, BlockState vineToPlace) {
        BlockState state;
        Block block;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !SlimeVineBlock.m_57853_((BlockGetter)worldIn, (BlockPos)pos.m_142300_(direction), (Direction)direction)) continue;
            worldIn.m_7731_(pos, (BlockState)vineToPlace.m_61124_((Property)SlimeVineBlock.m_57883_((Direction)direction), (Comparable)Boolean.TRUE), 2);
        }
        BlockPos vinePos = pos;
        for (int size = random.nextInt(8); size >= 0 && (block = (state = worldIn.m_8055_(vinePos)).m_60734_()) instanceof SlimeVineBlock; --size) {
            SlimeVineBlock vine = (SlimeVineBlock)block;
            vine.grow(worldIn, random, vinePos, state);
            vinePos = vinePos.m_7495_();
        }
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox bounds, ChunkPos chunk, BlockPos pos) {
        this.chunkGenerator = generator;
        if (this.variant.isPositionValid(world, this.f_73658_, generator)) {
            super.m_183269_(world, manager, generator, rand, bounds, chunk, pos);
        }
    }
}

