/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.ImmutableSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.mantle.util.SupplierCreativeTab;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.BloodSlimeBlock;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.PiglinHeadBlock;
import slimeknights.tconstruct.world.block.PiglinWallHeadBlock;
import slimeknights.tconstruct.world.block.SlimeDirtBlock;
import slimeknights.tconstruct.world.block.SlimeFungusBlock;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;
import slimeknights.tconstruct.world.block.SlimeLeavesBlock;
import slimeknights.tconstruct.world.block.SlimeNyliumBlock;
import slimeknights.tconstruct.world.block.SlimeSaplingBlock;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.block.SlimeWartBlock;
import slimeknights.tconstruct.world.block.StickySlimeBlock;
import slimeknights.tconstruct.world.data.WorldRecipeProvider;
import slimeknights.tconstruct.world.entity.EarthSlimeEntity;
import slimeknights.tconstruct.world.entity.EnderSlimeEntity;
import slimeknights.tconstruct.world.entity.SkySlimeEntity;
import slimeknights.tconstruct.world.entity.SlimePlacementPredicate;
import slimeknights.tconstruct.world.entity.TerracubeEntity;
import slimeknights.tconstruct.world.item.SlimeGrassSeedItem;
import slimeknights.tconstruct.world.worldgen.trees.SlimeTree;

public final class TinkerWorld
extends TinkerModule {
    public static final CreativeModeTab TAB_WORLD = new SupplierCreativeTab("tconstruct", "world", () -> new ItemStack(cobaltOre));
    static final Logger log = Util.getLogger("tinker_world");
    public static final PlantType SLIME_PLANT_TYPE = PlantType.get((String)"slime");
    private static final Item.Properties WORLD_PROPS = new Item.Properties().m_41491_(TAB_WORLD);
    private static final Function<Block, ? extends BlockItem> DEFAULT_BLOCK_ITEM = b -> new BlockItem(b, WORLD_PROPS);
    private static final Function<Block, ? extends BlockItem> TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, WORLD_PROPS);
    private static final Item.Properties HEAD_PROPS = new Item.Properties().m_41491_(TAB_WORLD).m_41497_(Rarity.UNCOMMON);
    public static final ItemObject<Block> cobaltOre = BLOCKS.register("cobalt_ore", () -> new Block(TinkerWorld.builder(Material.f_76278_, MaterialColor.f_76371_, SoundType.f_56723_).m_60999_().m_60978_(10.0f)), DEFAULT_BLOCK_ITEM);
    public static final ItemObject<Block> rawCobaltBlock = BLOCKS.register("raw_cobalt_block", () -> new Block(TinkerWorld.builder(Material.f_76278_, MaterialColor.f_76361_, SoundType.f_56723_).m_60999_().m_60913_(6.0f, 7.0f)), DEFAULT_BLOCK_ITEM);
    public static final ItemObject<Item> rawCobalt = ITEMS.register("raw_cobalt", WORLD_PROPS);
    public static final EnumObject<SlimeType, SlimeBlock> slime = Util.make(() -> {
        Function<SlimeType, BlockBehaviour.Properties> slimeProps = type -> TinkerWorld.builder(Material.f_76313_, type.getMapColor(), SoundType.f_56750_).m_60911_(0.8f).m_60918_(SoundType.f_56750_).m_60955_();
        return new EnumObject.Builder(SlimeType.class).putDelegate((Enum)SlimeType.EARTH, Blocks.f_50374_.delegate).put((Enum)SlimeType.SKY, (Supplier)BLOCKS.register("sky_slime", () -> new StickySlimeBlock((BlockBehaviour.Properties)slimeProps.apply(SlimeType.SKY), (state, other) -> true), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ICHOR, (Supplier)BLOCKS.register("ichor_slime", () -> new StickySlimeBlock(((BlockBehaviour.Properties)slimeProps.apply(SlimeType.ICHOR)).m_60953_(s -> SlimeType.ICHOR.getLightLevel()), (state, other) -> other.m_60734_() != state.m_60734_()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ENDER, (Supplier)BLOCKS.register("ender_slime", () -> new StickySlimeBlock((BlockBehaviour.Properties)slimeProps.apply(SlimeType.ENDER), (state, other) -> other.m_60734_() == state.m_60734_()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.BLOOD, (Supplier)BLOCKS.register("blood_slime", () -> new BloodSlimeBlock((BlockBehaviour.Properties)slimeProps.apply(SlimeType.BLOOD)), TOOLTIP_BLOCK_ITEM)).build();
    });
    public static final EnumObject<SlimeType, CongealedSlimeBlock> congealedSlime = BLOCKS.registerEnum(SlimeType.values(), "congealed_slime", type -> new CongealedSlimeBlock(TinkerWorld.builder(Material.f_76313_, type.getMapColor(), SoundType.f_56750_).m_60978_(0.5f).m_60911_(0.5f).m_60953_(s -> type.getLightLevel())), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeType, Block> slimeDirt = Util.make(() -> {
        Function<SlimeType, MaterialColor> color = type -> switch (type) {
            default -> MaterialColor.f_76399_;
            case SlimeType.SKY -> MaterialColor.f_76393_;
            case SlimeType.ENDER -> MaterialColor.f_76375_;
            case SlimeType.ICHOR -> MaterialColor.f_76373_;
        };
        return BLOCKS.registerEnum(SlimeType.TRUE_SLIME, "slime_dirt", type -> new SlimeDirtBlock(TinkerWorld.builder(Material.f_76314_, (MaterialColor)color.apply((SlimeType)((Object)((Object)type))), SoundType.f_56750_).m_60978_(1.9f)), TOOLTIP_BLOCK_ITEM);
    });
    public static final EnumObject<SlimeType, Block> allDirt = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.BLOOD, (Supplier)Blocks.f_50493_.delegate).putAll(slimeDirt).build();
    public static final EnumObject<SlimeType, Block> vanillaSlimeGrass;
    public static final EnumObject<SlimeType, Block> earthSlimeGrass;
    public static final EnumObject<SlimeType, Block> skySlimeGrass;
    public static final EnumObject<SlimeType, Block> enderSlimeGrass;
    public static final EnumObject<SlimeType, Block> ichorSlimeGrass;
    public static final Map<SlimeType, EnumObject<SlimeType, Block>> slimeGrass;
    public static final EnumObject<SlimeType, SlimeGrassSeedItem> slimeGrassSeeds;
    public static final WoodBlockObject greenheart;
    public static final WoodBlockObject skyroot;
    public static final WoodBlockObject bloodshroom;
    public static final EnumObject<SlimeType, SlimeTallGrassBlock> slimeFern;
    public static final EnumObject<SlimeType, SlimeTallGrassBlock> slimeTallGrass;
    public static final EnumObject<SlimeType, Block> slimeSapling;
    public static final EnumObject<SlimeType, Block> slimeLeaves;
    public static final ItemObject<SlimeVineBlock> skySlimeVine;
    public static final ItemObject<SlimeVineBlock> enderSlimeVine;
    public static final GeodeItemObject earthGeode;
    public static final RegistryObject<ConfiguredFeature<GeodeConfiguration, Feature<GeodeConfiguration>>> configuredEarthGeode;
    public static final RegistryObject<PlacedFeature> placedEarthGeode;
    public static final GeodeItemObject skyGeode;
    public static final RegistryObject<ConfiguredFeature<GeodeConfiguration, Feature<GeodeConfiguration>>> configuredSkyGeode;
    public static final RegistryObject<PlacedFeature> placedSkyGeode;
    public static final GeodeItemObject ichorGeode;
    public static final RegistryObject<ConfiguredFeature<GeodeConfiguration, Feature<GeodeConfiguration>>> configuredIchorGeode;
    public static final RegistryObject<PlacedFeature> placedIchorGeode;
    public static final GeodeItemObject enderGeode;
    public static final RegistryObject<ConfiguredFeature<GeodeConfiguration, Feature<GeodeConfiguration>>> configuredEnderGeode;
    public static final RegistryObject<PlacedFeature> placedEnderGeode;
    public static final EnumObject<TinkerHeadType, SkullBlock> heads;
    public static final EnumObject<TinkerHeadType, WallSkullBlock> wallHeads;
    public static final EnumObject<TinkerHeadType, StandingAndWallBlockItem> headItems;
    public static final RegistryObject<EntityType<EarthSlimeEntity>> earthSlimeEntity;
    public static final RegistryObject<EntityType<SkySlimeEntity>> skySlimeEntity;
    public static final RegistryObject<EntityType<EnderSlimeEntity>> enderSlimeEntity;
    public static final RegistryObject<EntityType<TerracubeEntity>> terracubeEntity;
    public static final RegistryObject<SimpleParticleType> skySlimeParticle;
    public static final RegistryObject<SimpleParticleType> enderSlimeParticle;
    public static final RegistryObject<SimpleParticleType> terracubeParticle;
    public static RegistryObject<ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>>> configuredSmallCobaltOre;
    public static RegistryObject<PlacedFeature> placedSmallCobaltOre;
    public static RegistryObject<ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>>> configuredLargeCobaltOre;
    public static RegistryObject<PlacedFeature> placedLargeCobaltOre;

    private static Function<WoodBlockObject.WoodVariant, BlockBehaviour.Properties> createSlimewood(MaterialColor planks, MaterialColor bark) {
        return type -> switch (type) {
            case WoodBlockObject.WoodVariant.WOOD -> BlockBehaviour.Properties.m_60944_((Material)Material.f_76321_, (MaterialColor)bark).m_60918_(SoundType.f_56736_).m_60999_();
            case WoodBlockObject.WoodVariant.LOG -> BlockBehaviour.Properties.m_60947_((Material)Material.f_76321_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? planks : bark).m_60918_(SoundType.f_56736_).m_60999_();
            default -> BlockBehaviour.Properties.m_60944_((Material)Material.f_76321_, (MaterialColor)planks).m_60918_(SoundType.f_56750_);
        };
    }

    @SubscribeEvent
    void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)earthSlimeEntity.get(), Monster.m_33035_().m_22265_());
        event.put((EntityType)skySlimeEntity.get(), Monster.m_33035_().m_22265_());
        event.put((EntityType)enderSlimeEntity.get(), Monster.m_33035_().m_22265_());
        event.put((EntityType)terracubeEntity.get(), Monster.m_33035_().m_22265_());
    }

    private static void setWoodFireInfo(FireBlock fireBlock, WoodBlockObject wood) {
        fireBlock.m_53444_((Block)wood.get(), 5, 20);
        fireBlock.m_53444_((Block)wood.getSlab(), 5, 20);
        fireBlock.m_53444_((Block)wood.getStairs(), 5, 20);
        fireBlock.m_53444_((Block)wood.getFence(), 5, 20);
        fireBlock.m_53444_((Block)wood.getFenceGate(), 5, 20);
        fireBlock.m_53444_(wood.getLog(), 5, 5);
        fireBlock.m_53444_(wood.getStrippedLog(), 5, 5);
        fireBlock.m_53444_(wood.getWood(), 5, 5);
        fireBlock.m_53444_(wood.getStrippedWood(), 5, 5);
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)earthSlimeEntity.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SlimePlacementPredicate(TinkerTags.Blocks.EARTH_SLIME_SPAWN));
        SpawnPlacements.m_21754_((EntityType)((EntityType)skySlimeEntity.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SlimePlacementPredicate(TinkerTags.Blocks.SKY_SLIME_SPAWN));
        SpawnPlacements.m_21754_((EntityType)((EntityType)enderSlimeEntity.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SlimePlacementPredicate(TinkerTags.Blocks.ENDER_SLIME_SPAWN));
        SpawnPlacements.m_21754_((EntityType)((EntityType)terracubeEntity.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TerracubeEntity::canSpawnHere);
        event.enqueueWork(() -> {
            slimeLeaves.forEach((type, block) -> ComposterBlock.m_51920_((float)(type.isNether() ? 0.85f : 0.35f), (ItemLike)block));
            slimeSapling.forEach(block -> ComposterBlock.m_51920_((float)0.35f, (ItemLike)block));
            slimeTallGrass.forEach(block -> ComposterBlock.m_51920_((float)0.35f, (ItemLike)block));
            slimeFern.forEach(block -> ComposterBlock.m_51920_((float)0.65f, (ItemLike)block));
            slimeGrassSeeds.forEach(block -> ComposterBlock.m_51920_((float)0.35f, (ItemLike)block));
            ComposterBlock.m_51920_((float)0.5f, skySlimeVine);
            ComposterBlock.m_51920_((float)0.5f, enderSlimeVine);
            OptionalDispenseItemBehavior dispenseArmor = new OptionalDispenseItemBehavior(){

                protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
                    return stack;
                }
            };
            heads.forEach(arg_0 -> TinkerWorld.lambda$commonSetup$62((DispenseItemBehavior)dispenseArmor, arg_0));
            heads.forEach(head -> FireworkStarRecipe.f_43879_.put(head.m_5456_(), FireworkRocketItem.Shape.CREEPER));
            event.enqueueWork(() -> {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.addAll((Iterable)BlockEntityType.f_58931_.f_58915_);
                heads.forEach(head -> builder.add(head));
                wallHeads.forEach(head -> builder.add(head));
                BlockEntityType.f_58931_.f_58915_ = builder.build();
            });
        });
        event.enqueueWork(() -> {
            FireBlock fireblock = (FireBlock)Blocks.f_50083_;
            BiConsumer<SlimeType, Block> plantFireInfo = (type, block) -> {
                if (type != SlimeType.BLOOD && type != SlimeType.ICHOR) {
                    fireblock.m_53444_(block, 30, 60);
                }
            };
            slimeLeaves.forEach(plantFireInfo);
            slimeTallGrass.forEach(plantFireInfo);
            slimeFern.forEach(plantFireInfo);
            fireblock.m_53444_((Block)skySlimeVine.get(), 15, 100);
            fireblock.m_53444_((Block)enderSlimeVine.get(), 15, 100);
        });
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.m_123914_((DataProvider)new WorldRecipeProvider(datagenerator));
        }
    }

    private static SkullBlock makeHead(TinkerHeadType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(1.0f);
        if (type == TinkerHeadType.PIGLIN || type == TinkerHeadType.PIGLIN_BRUTE || type == TinkerHeadType.ZOMBIFIED_PIGLIN) {
            return new PiglinHeadBlock(type, props);
        }
        return new SkullBlock((SkullBlock.Type)type, props);
    }

    private static WallSkullBlock makeWallHead(TinkerHeadType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(1.0f).lootFrom(() -> (Block)heads.get((Enum)type));
        if (type == TinkerHeadType.PIGLIN || type == TinkerHeadType.PIGLIN_BRUTE || type == TinkerHeadType.ZOMBIFIED_PIGLIN) {
            return new PiglinWallHeadBlock(type, props);
        }
        return new WallSkullBlock((SkullBlock.Type)type, props);
    }

    private static /* synthetic */ void lambda$commonSetup$62(DispenseItemBehavior dispenseArmor, SkullBlock head) {
        DispenserBlock.m_52672_((ItemLike)head, (DispenseItemBehavior)dispenseArmor);
    }

    static {
        slimeGrass = new EnumMap<SlimeType, EnumObject<SlimeType, Block>>(SlimeType.class);
        Function<SlimeType, BlockBehaviour.Properties> slimeGrassProps = type -> TinkerWorld.builder(Material.f_76315_, type.getMapColor(), SoundType.f_56750_).m_60978_(2.0f).m_60999_().m_60977_();
        Function<SlimeType, Block> slimeGrassRegister = type -> type.isNether() ? new SlimeNyliumBlock((BlockBehaviour.Properties)slimeGrassProps.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)) : new SlimeGrassBlock((BlockBehaviour.Properties)slimeGrassProps.apply((SlimeType)((Object)type)), (SlimeType)((Object)type));
        vanillaSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "vanilla_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        earthSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "earth_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        skySlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "sky_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        enderSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "ender_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        ichorSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "ichor_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        slimeGrass.put(SlimeType.BLOOD, vanillaSlimeGrass);
        slimeGrass.put(SlimeType.EARTH, earthSlimeGrass);
        slimeGrass.put(SlimeType.SKY, skySlimeGrass);
        slimeGrass.put(SlimeType.ENDER, enderSlimeGrass);
        slimeGrass.put(SlimeType.ICHOR, ichorSlimeGrass);
        slimeGrassSeeds = ITEMS.registerEnum(SlimeType.values(), "slime_grass_seeds", type -> new SlimeGrassSeedItem(WORLD_PROPS, (SlimeType)((Object)type)));
        greenheart = BLOCKS.registerWood("greenheart", TinkerWorld.createSlimewood(MaterialColor.f_76417_, MaterialColor.f_76363_), false, TAB_WORLD);
        skyroot = BLOCKS.registerWood("skyroot", TinkerWorld.createSlimewood(MaterialColor.f_76421_, MaterialColor.f_76381_), false, TAB_WORLD);
        bloodshroom = BLOCKS.registerWood("bloodshroom", TinkerWorld.createSlimewood(MaterialColor.f_76364_, MaterialColor.f_76413_), false, TAB_WORLD);
        Function<SlimeType, BlockBehaviour.Properties> props = type -> {
            BlockBehaviour.Properties properties = type.isNether() ? TinkerWorld.builder(Material.f_76303_, type.getMapColor(), SoundType.f_56712_) : TinkerWorld.builder(Material.f_76302_, type.getMapColor(), SoundType.f_56740_);
            return properties.m_60966_().m_60910_();
        };
        slimeFern = BLOCKS.registerEnum(SlimeType.values(), "slime_fern", type -> new SlimeTallGrassBlock((BlockBehaviour.Properties)props.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)), DEFAULT_BLOCK_ITEM);
        slimeTallGrass = BLOCKS.registerEnum(SlimeType.values(), "slime_tall_grass", type -> new SlimeTallGrassBlock((BlockBehaviour.Properties)props.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)), DEFAULT_BLOCK_ITEM);
        slimeSapling = Util.make(() -> {
            Function<SlimeType, BlockBehaviour.Properties> props = type -> TinkerWorld.builder(Material.f_76300_, type.getMapColor(), type.isNether() ? SoundType.f_56711_ : SoundType.f_56740_).m_60966_().m_60910_();
            return new EnumObject.Builder(SlimeType.class).putAll(BLOCKS.registerEnum(SlimeType.OVERWORLD, "slime_sapling", type -> new SlimeSaplingBlock(new SlimeTree((SlimeType)((Object)((Object)type))), (SlimeType)((Object)((Object)type)), ((BlockBehaviour.Properties)props.apply((SlimeType)((Object)((Object)type)))).m_60977_()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.BLOOD, (Supplier)BLOCKS.register("blood_slime_sapling", () -> new SlimeFungusBlock((BlockBehaviour.Properties)props.apply(SlimeType.BLOOD), () -> Holder.m_205706_((Holder)((Holder)TinkerStructures.bloodSlimeFungus.getHolder().orElseThrow()))), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ICHOR, (Supplier)BLOCKS.register("ichor_slime_sapling", () -> new SlimeFungusBlock((BlockBehaviour.Properties)props.apply(SlimeType.ICHOR), () -> Holder.m_205706_((Holder)((Holder)TinkerStructures.ichorSlimeFungus.getHolder().orElseThrow()))), HIDDEN_BLOCK_ITEM)).build();
        });
        slimeLeaves = BLOCKS.registerEnum(SlimeType.values(), "slime_leaves", type -> {
            if (type.isNether()) {
                return new SlimeWartBlock(TinkerWorld.builder(Material.f_76315_, type.getMapColor(), SoundType.f_56719_).m_60978_(1.5f).m_60922_((s, w, p, e) -> false), (SlimeType)((Object)type));
            }
            return new SlimeLeavesBlock(TinkerWorld.builder(Material.f_76274_, type.getMapColor(), SoundType.f_56740_).m_60978_(1.0f).m_60977_().m_60955_().m_60922_((s, w, p, e) -> false), (SlimeType)((Object)type));
        }, DEFAULT_BLOCK_ITEM);
        props = type -> TinkerWorld.builder(Material.f_76302_, type.getMapColor(), SoundType.f_56740_).m_60978_(0.75f).m_60910_().m_60977_();
        skySlimeVine = BLOCKS.register("sky_slime_vine", () -> new SlimeVineBlock((BlockBehaviour.Properties)props.apply(SlimeType.SKY), SlimeType.SKY), DEFAULT_BLOCK_ITEM);
        enderSlimeVine = BLOCKS.register("ender_slime_vine", () -> new SlimeVineBlock((BlockBehaviour.Properties)props.apply(SlimeType.ENDER), SlimeType.ENDER), DEFAULT_BLOCK_ITEM);
        earthGeode = BLOCKS.registerGeode("earth_slime_crystal", MaterialColor.f_76417_, Sounds.EARTH_CRYSTAL, Sounds.EARTH_CRYSTAL_CHIME.getSound(), Sounds.EARTH_CRYSTAL_CLUSTER, 3, WORLD_PROPS);
        configuredEarthGeode = CONFIGURED_FEATURES.registerGeode("earth_geode", earthGeode, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50129_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50122_), new GeodeLayerSettings(1.7, 2.2, 3.2, 5.2), new GeodeCrackSettings(0.95, 2.0, 2), (IntProvider)UniformInt.m_146622_((int)6, (int)9), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)2), 16, 1);
        placedEarthGeode = PLACED_FEATURES.registerGeode("earth_geode", configuredEarthGeode, RarityFilter.m_191900_((int)128), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)6), (VerticalAnchor)VerticalAnchor.m_158930_((int)54)));
        skyGeode = BLOCKS.registerGeode("sky_slime_crystal", MaterialColor.f_76361_, Sounds.SKY_CRYSTAL, Sounds.SKY_CRYSTAL_CHIME.getSound(), Sounds.SKY_CRYSTAL_CLUSTER, 0, WORLD_PROPS);
        configuredSkyGeode = CONFIGURED_FEATURES.registerGeode("sky_geode", skyGeode, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50354_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50228_), new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.55, 0.5, 2), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)2, (int)3), (IntProvider)ConstantInt.m_146483_((int)1), 8, 5);
        placedSkyGeode = PLACED_FEATURES.registerGeode("sky_geode", configuredSkyGeode, RarityFilter.m_191900_((int)64), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)16), (VerticalAnchor)VerticalAnchor.m_158922_((int)54)));
        ichorGeode = BLOCKS.registerGeode("ichor_slime_crystal", MaterialColor.f_76413_, Sounds.ICHOR_CRYSTAL, Sounds.ICHOR_CRYSTAL_CHIME.getSound(), Sounds.ICHOR_CRYSTAL_CLUSTER, 10, WORLD_PROPS);
        configuredIchorGeode = CONFIGURED_FEATURES.registerGeode("ichor_geode", ichorGeode, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50450_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50134_), new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.75, 2.0, 2), (IntProvider)UniformInt.m_146622_((int)4, (int)6), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)2), 24, 20);
        placedIchorGeode = PLACED_FEATURES.registerGeode("ichor_geode", configuredIchorGeode, RarityFilter.m_191900_((int)52), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158935_((int)48), (VerticalAnchor)VerticalAnchor.m_158935_((int)16)));
        enderGeode = BLOCKS.registerGeode("ender_slime_crystal", MaterialColor.f_76422_, Sounds.ENDER_CRYSTAL, Sounds.ENDER_CRYSTAL_CHIME.getSound(), Sounds.ENDER_CRYSTAL_CLUSTER, 7, WORLD_PROPS);
        configuredEnderGeode = CONFIGURED_FEATURES.registerGeode("ender_geode", enderGeode, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50080_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50259_), new GeodeLayerSettings(1.7, 2.2, 3.2, 5.2), new GeodeCrackSettings(0.45, 1.0, 2), (IntProvider)UniformInt.m_146622_((int)4, (int)10), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)2), 16, 10000);
        placedEnderGeode = PLACED_FEATURES.registerGeode("ender_geode", configuredEnderGeode, RarityFilter.m_191900_((int)256), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)16), (VerticalAnchor)VerticalAnchor.m_158930_((int)64)));
        heads = BLOCKS.registerEnumNoItem(TinkerHeadType.values(), "head", TinkerWorld::makeHead);
        wallHeads = BLOCKS.registerEnumNoItem(TinkerHeadType.values(), "wall_head", TinkerWorld::makeWallHead);
        headItems = ITEMS.registerEnum(TinkerHeadType.values(), "head", type -> new StandingAndWallBlockItem((Block)heads.get((Enum)type), (Block)wallHeads.get((Enum)type), HEAD_PROPS));
        earthSlimeEntity = ENTITIES.register("earth_slime", () -> EntityType.Builder.m_20704_(EarthSlimeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(10).m_20699_(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (EarthSlimeEntity)((EntityType)earthSlimeEntity.get()).m_20615_(world)));
        skySlimeEntity = ENTITIES.registerWithEgg("sky_slime", () -> EntityType.Builder.m_20704_(SkySlimeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(20).m_20699_(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (SkySlimeEntity)((EntityType)skySlimeEntity.get()).m_20615_(world)), 4714485, 11337716);
        enderSlimeEntity = ENTITIES.registerWithEgg("ender_slime", () -> EntityType.Builder.m_20704_(EnderSlimeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).m_20699_(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (EnderSlimeEntity)((EntityType)enderSlimeEntity.get()).m_20615_(world)), 6488240, 13860095);
        terracubeEntity = ENTITIES.registerWithEgg("terracube", () -> EntityType.Builder.m_20704_(TerracubeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(8).m_20699_(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (TerracubeEntity)((EntityType)terracubeEntity.get()).m_20615_(world)), 11516374, 10594225);
        skySlimeParticle = PARTICLE_TYPES.register("sky_slime", () -> new SimpleParticleType(false));
        enderSlimeParticle = PARTICLE_TYPES.register("ender_slime", () -> new SimpleParticleType(false));
        terracubeParticle = PARTICLE_TYPES.register("terracube", () -> new SimpleParticleType(false));
        configuredSmallCobaltOre = CONFIGURED_FEATURES.registerSupplier("cobalt_ore_small", () -> Feature.f_65731_, () -> new OreConfiguration(OreFeatures.f_195074_, ((Block)cobaltOre.get()).m_49966_(), 4));
        placedSmallCobaltOre = PLACED_FEATURES.register("cobalt_ore_small", configuredSmallCobaltOre, new PlacementModifier[]{CountPlacement.m_191628_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195358_, BiomeFilter.m_191561_()});
        configuredLargeCobaltOre = CONFIGURED_FEATURES.registerSupplier("cobalt_ore_large", () -> Feature.f_65731_, () -> new OreConfiguration(OreFeatures.f_195074_, ((Block)cobaltOre.get()).m_49966_(), 6));
        placedLargeCobaltOre = PLACED_FEATURES.register("cobalt_ore_large", configuredSmallCobaltOre, new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)32)), BiomeFilter.m_191561_()});
    }
}

