/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class RepairKitStats
extends BaseMaterialStats
implements IRepairableMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("repair_kit"));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription());
    public static final RepairKitStats DEFAULT = new RepairKitStats(1);
    private final int durability;

    public RepairKitStats(FriendlyByteBuf buffer) {
        this.durability = buffer.readInt();
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<Component> getLocalizedInfo() {
        return Collections.singletonList(ToolStats.DURABILITY.formatValue(this.durability));
    }

    @Override
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.durability);
    }

    public RepairKitStats(int durability) {
        this.durability = durability;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepairKitStats)) {
            return false;
        }
        RepairKitStats other = (RepairKitStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getDurability() == other.getDurability();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RepairKitStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDurability();
        return result;
    }

    public String toString() {
        return "RepairKitStats(durability=" + this.getDurability() + ")";
    }

    @Override
    public int getDurability() {
        return this.durability;
    }
}

