/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.tools.logic.InteractionHandler;

public enum OnChestplateUsePacket implements IThreadsafePacket
{
    MAINHAND(InteractionHand.MAIN_HAND),
    OFFHAND(InteractionHand.OFF_HAND);

    private final InteractionHand hand;

    public static OnChestplateUsePacket from(InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND ? OFFHAND : MAINHAND;
    }

    public static OnChestplateUsePacket read(FriendlyByteBuf buffer) {
        return OnChestplateUsePacket.from((InteractionHand)buffer.m_130066_(InteractionHand.class));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.hand);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        InteractionResult result;
        ItemStack chestplate;
        ServerPlayer player = context.getSender();
        if (player != null && !player.m_5833_() && (chestplate = player.m_6844_(EquipmentSlot.CHEST)).m_204117_(TinkerTags.Items.CHESTPLATES) && player.m_21120_(this.hand).m_41619_() && (result = InteractionHandler.onChestplateUse((Player)player, chestplate, this.hand)).m_19080_()) {
            player.m_21011_(this.hand, true);
        }
    }

    private OnChestplateUsePacket(InteractionHand hand) {
        this.hand = hand;
    }
}

