/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ReinforcedModifier
extends IncrementalModifier {
    public static float diminishingPercent(float level) {
        if (level < 5.0f) {
            return 0.025f * level * (11.0f - level);
        }
        return 0.75f + (level - 5.0f) * 0.05f;
    }

    protected float getPercentage(float level) {
        return ReinforcedModifier.diminishingPercent(level);
    }

    @Override
    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        float percentage = this.getPercentage(this.getScaledLevel(tool, level));
        if (percentage >= 1.0f) {
            return 0;
        }
        if (percentage <= 0.0f) {
            return amount;
        }
        int dealt = 0;
        for (int i = 0; i < amount; ++i) {
            if (!(RANDOM.nextFloat() >= percentage)) continue;
            ++dealt;
        }
        return dealt;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float reinforced = tool.getModifierLevel((Modifier)TinkerModifiers.unbreakable.get()) > 0 ? 1.0f : this.getPercentage(this.getScaledLevel(tool, level));
        tooltip.add((Component)this.applyStyle(new TextComponent(Util.PERCENT_FORMAT.format(reinforced) + " ").m_7220_(this.makeDisplayName())));
    }
}

