/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IShearModifier;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.effect.MagneticEffect;

public class MagneticModifier
extends TotalArmorLevelModifier
implements IHarvestModifier,
IShearModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> MAGNET = TConstruct.createKey("magnet");

    public MagneticModifier() {
        super(MAGNET);
        MinecraftForge.EVENT_BUS.addListener(MagneticModifier::onLivingTick);
    }

    @Override
    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        if (!context.isAOE()) {
            ((MagneticEffect)((Object)TinkerModifiers.magneticEffect.get())).apply(context.getLiving(), 30, level - 1);
        }
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack()) {
            ((MagneticEffect)((Object)TinkerModifiers.magneticEffect.get())).apply(context.getAttacker(), 30, level - 1);
        }
        return 0;
    }

    @Override
    public void afterHarvest(IToolStackView tool, int level, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
        Player player = context.m_43723_();
        if (player != null) {
            ((MagneticEffect)((Object)TinkerModifiers.magneticEffect.get())).apply((LivingEntity)player, 30, level - 1);
        }
    }

    @Override
    public void afterShearEntity(IToolStackView tool, int level, Player player, Entity entity, boolean isTarget) {
        if (isTarget) {
            ((MagneticEffect)((Object)TinkerModifiers.magneticEffect.get())).apply((LivingEntity)player, 30, level - 1);
        }
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IHarvestModifier.class || type == IShearModifier.class) {
            return (T)this;
        }
        return null;
    }

    private static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        int level;
        LivingEntity entity = event.getEntityLiving();
        if (!entity.m_5833_() && (entity.f_19797_ & 1) == 0 && (level = ModifierUtil.getTotalModifierLevel(entity, MAGNET)) > 0) {
            MagneticModifier.applyMagnet(entity, level);
        }
    }

    public static void applyMagnet(LivingEntity entity, int amplifier) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        float range = 3.0f + 1.0f * (float)amplifier;
        List items = entity.f_19853_.m_45976_(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
        int pulled = 0;
        for (ItemEntity item : items) {
            if (item.m_32055_().m_41619_() || !item.m_6084_()) continue;
            Vec3 vec = entity.m_20182_().m_82492_(item.m_20185_(), item.m_20186_(), item.m_20189_()).m_82541_().m_82490_((double)(0.05f + (float)amplifier * 0.05f));
            if (!item.m_20068_()) {
                vec = vec.m_82520_(0.0, (double)0.04f, 0.0);
            }
            item.m_20256_(item.m_20184_().m_82549_(vec));
            if ((pulled += item.m_32055_().m_41613_()) <= 200) continue;
            break;
        }
    }
}

