/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class SelfDestructiveModifier
extends NoLevelsModifier
implements IArmorInteractModifier {
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.fromString("68ee3026-1d50-4eb4-914e-a8b05fbfdb71"), TConstruct.prefix("self_destruct_slowdown"), (double)-0.9f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final DamageSource SELF_DESTRUCT = new DamageSource(TConstruct.prefix("self_destruct")).m_19380_().m_19375_();
    private static final TinkerDataCapability.TinkerDataKey<Integer> FUSE_FINISH = TConstruct.createKey("self_destruct_finish");

    public SelfDestructiveModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TickEvent.PlayerTickEvent.class, SelfDestructiveModifier::playerTick);
    }

    @Override
    public boolean startArmorInteract(IToolStackView tool, int level, Player player, EquipmentSlot slot) {
        if (player.m_6144_()) {
            player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(FUSE_FINISH, player.f_19797_ + 30));
            player.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
            AttributeInstance instance = player.m_21204_().m_22146_(Attributes.f_22279_);
            if (instance != null && !instance.m_22109_(SPEED_MODIFIER)) {
                instance.m_22118_(SPEED_MODIFIER);
            }
            return true;
        }
        return false;
    }

    private static void restoreSpeed(LivingEntity livingEntity) {
        AttributeInstance instance = livingEntity.m_21204_().m_22146_(Attributes.f_22279_);
        if (instance != null) {
            instance.m_22130_(SPEED_MODIFIER);
        }
    }

    @Override
    public void stopArmorInteract(IToolStackView tool, int level, Player player, EquipmentSlot slot) {
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.remove(FUSE_FINISH));
        SelfDestructiveModifier.restoreSpeed((LivingEntity)player);
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        context.getTinkerData().ifPresent(data -> data.remove(FUSE_FINISH));
        SelfDestructiveModifier.restoreSpeed(context.getEntity());
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return SelfDestructiveModifier.tryModuleMatch(type, IArmorInteractModifier.class, this);
    }

    private static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.f_19853_.f_46443_ && !event.player.m_5833_()) {
            event.player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                Integer fuseFinish = data.get(FUSE_FINISH);
                if (fuseFinish != null && fuseFinish <= event.player.f_19797_) {
                    event.player.f_19853_.m_46511_((Entity)event.player, event.player.m_20185_(), event.player.m_20186_(), event.player.m_20189_(), 3.0f, Explosion.BlockInteraction.DESTROY);
                    event.player.m_6469_(SELF_DESTRUCT, 99999.0f);
                    if (event.player.m_21223_() > 0.0f) {
                        SelfDestructiveModifier.restoreSpeed((LivingEntity)event.player);
                    }
                    data.remove(FUSE_FINISH);
                }
            });
        }
    }
}

