/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class RagingModifier
extends Modifier {
    private static final float LOWEST_HEALTH = 2.0f;
    private static final float HIGHEST_HEALTH = 10.0f;
    private static final float DAMAGE_PER_LEVEL = 4.0f;

    private static float getBonus(LivingEntity attacker, int level) {
        float health = attacker.m_21223_();
        float max = attacker.m_21233_();
        if (max < 10.0f) {
            health += 10.0f - max;
        }
        if (health <= 2.0f) {
            return (float)level * 4.0f;
        }
        if (health < 10.0f) {
            return (float)level * 4.0f * (10.0f - health) / 8.0f;
        }
        return 0.0f;
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage + RagingModifier.getBonus(context.getAttacker(), level);
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus = level * 4;
        if (player != null && key == TooltipKey.SHIFT) {
            bonus = RagingModifier.getBonus((LivingEntity)player, level);
        }
        this.addDamageTooltip(tool, bonus, tooltip);
    }
}

