/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class TemperateModifier
extends Modifier {
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final float MAX_BOOST = 7.5f;
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "temperate.mining_speed");

    private static float getBonus(Player player, BlockPos pos, int level) {
        return Math.abs(((Biome)player.f_19853_.m_204166_(pos).m_203334_()).m_47505_(pos) - 0.75f) * (float)level * 7.5f / 1.25f;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() + TemperateModifier.getBonus(event.getPlayer(), event.getPos(), level) * tool.getMultiplier(ToolStats.MINING_SPEED) * miningSpeedModifier);
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus;
        if (tool.hasTag(TinkerTags.Items.HARVEST) && (bonus = player != null && key == TooltipKey.SHIFT ? TemperateModifier.getBonus(player, player.m_142538_(), level) : (float)level * 7.5f) > 0.01f) {
            this.addFlatBoost(MINING_SPEED, bonus * tool.getMultiplier(ToolStats.MINING_SPEED), tooltip);
        }
    }
}

