/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data.material;

import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidContainerIngredient;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.json.TagDifferencePresentCondition;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.world.TinkerWorld;

public class MaterialRecipeProvider
extends BaseRecipeProvider
implements IMaterialRecipeHelper {
    public MaterialRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public String m_6055_() {
        return "Tinkers' Construct Material Recipe";
    }

    @Override
    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.addMaterialItems(consumer);
        this.addMaterialSmeltery(consumer);
    }

    private void addMaterialItems(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN), 1, 2, folder + "wood/sticks");
        this.materialRecipe(consumer, MaterialIds.bamboo, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41911_}), 1, 4, folder + "wood/bamboo");
        this.materialRecipe(consumer, MaterialIds.oak, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42647_}), 1, 1, folder + "wood/planks/oak");
        this.materialRecipe(consumer, MaterialIds.spruce, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42700_}), 1, 1, folder + "wood/planks/spruce");
        this.materialRecipe(consumer, MaterialIds.birch, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42753_}), 1, 1, folder + "wood/planks/birch");
        this.materialRecipe(consumer, MaterialIds.jungle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42794_}), 1, 1, folder + "wood/planks/jungle");
        this.materialRecipe(consumer, MaterialIds.darkOak, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42796_}), 1, 1, folder + "wood/planks/dark_oak");
        this.materialRecipe(consumer, MaterialIds.acacia, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42795_}), 1, 1, folder + "wood/planks/acacia");
        this.materialRecipe(consumer, MaterialIds.crimson, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42797_}), 1, 1, folder + "wood/planks/crimson");
        this.materialRecipe(consumer, MaterialIds.warped, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42798_}), 1, 1, folder + "wood/planks/warped");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{TagDifferencePresentCondition.ofKeys(ItemTags.f_13168_, TinkerTags.Items.VARIANT_PLANKS)}), MaterialIds.wood, (Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_13168_), (Ingredient)Ingredient.m_204132_(TinkerTags.Items.VARIANT_PLANKS)), 1, 1, folder + "wood/planks/default");
        this.materialRecipe(consumer, MaterialIds.oak, Ingredient.m_204132_((TagKey)ItemTags.f_13184_), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50705_)), folder + "wood/logs/oak");
        this.materialRecipe(consumer, MaterialIds.spruce, Ingredient.m_204132_((TagKey)ItemTags.f_13188_), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50741_)), folder + "wood/logs/spruce");
        this.materialRecipe(consumer, MaterialIds.birch, Ingredient.m_204132_((TagKey)ItemTags.f_13185_), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50742_)), folder + "wood/logs/birch");
        this.materialRecipe(consumer, MaterialIds.jungle, Ingredient.m_204132_((TagKey)ItemTags.f_13187_), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50743_)), folder + "wood/logs/jungle");
        this.materialRecipe(consumer, MaterialIds.darkOak, Ingredient.m_204132_((TagKey)ItemTags.f_13183_), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50745_)), folder + "wood/logs/dark_oak");
        this.materialRecipe(consumer, MaterialIds.acacia, Ingredient.m_204132_((TagKey)ItemTags.f_13186_), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50744_)), folder + "wood/logs/acacia");
        this.materialRecipe(consumer, MaterialIds.crimson, Ingredient.m_204132_((TagKey)ItemTags.f_13189_), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50655_)), folder + "wood/logs/crimson");
        this.materialRecipe(consumer, MaterialIds.warped, Ingredient.m_204132_((TagKey)ItemTags.f_13190_), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Blocks.f_50656_)), folder + "wood/logs/warped");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{TagDifferencePresentCondition.ofKeys(ItemTags.f_13182_, TinkerTags.Items.VARIANT_LOGS)}), MaterialIds.wood, (Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_13182_), (Ingredient)Ingredient.m_204132_(TinkerTags.Items.VARIANT_LOGS)), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)Items.f_42398_, 2)), folder + "wood/logs/default");
        this.materialRecipe(consumer, MaterialIds.stone, Ingredient.m_204132_(TinkerTags.Items.STONE), 1, 1, folder + "rock/stone");
        this.materialRecipe(consumer, MaterialIds.andesite, Ingredient.m_204132_(TinkerTags.Items.ANDESITE), 1, 1, folder + "rock/andesite");
        this.materialRecipe(consumer, MaterialIds.diorite, Ingredient.m_204132_(TinkerTags.Items.DIORITE), 1, 1, folder + "rock/diorite");
        this.materialRecipe(consumer, MaterialIds.granite, Ingredient.m_204132_(TinkerTags.Items.GRANITE), 1, 1, folder + "rock/granite");
        this.materialRecipe(consumer, MaterialIds.deepslate, Ingredient.m_204132_(TinkerTags.Items.DEEPSLATE), 1, 1, folder + "rock/deepslate");
        this.materialRecipe(consumer, MaterialIds.blackstone, Ingredient.m_204132_(TinkerTags.Items.BLACKSTONE), 1, 1, folder + "rock/blackstone");
        this.materialRecipe(consumer, MaterialIds.flint, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_}), 1, 1, folder + "flint");
        this.materialRecipe(consumer, MaterialIds.basalt, Ingredient.m_204132_(TinkerTags.Items.BASALT), 1, 1, folder + "flint_basalt");
        this.materialRecipe(consumer, MaterialIds.bone, Ingredient.m_204132_((TagKey)Tags.Items.BONES), 1, 1, folder + "bone");
        this.materialRecipe(consumer, MaterialIds.necroticBone, Ingredient.m_204132_(TinkerTags.Items.WITHER_BONES), 1, 1, folder + "necrotic_bone");
        this.materialRecipe(consumer, MaterialIds.string, Ingredient.m_204132_((TagKey)Tags.Items.STRING), 1, 4, folder + "string");
        this.materialRecipe(consumer, MaterialIds.leather, Ingredient.m_204132_((TagKey)Tags.Items.LEATHER), 1, 1, folder + "leather");
        this.materialRecipe(consumer, MaterialIds.vine, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42029_, Items.f_41908_, Items.f_41907_}), 1, 1, folder + "vine");
        this.metalMaterialRecipe(consumer, MaterialIds.iron, folder, "iron", false);
        this.materialRecipe(consumer, MaterialIds.searedStone, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.searedBrick}), 1, 2, folder + "seared_stone/brick");
        this.materialRecipe(consumer, MaterialIds.searedStone, Ingredient.m_204132_(TinkerTags.Items.SEARED_BLOCKS), 2, 1, ItemOutput.fromItem(TinkerSmeltery.searedBrick), folder + "seared_stone/block");
        this.materialRecipe(consumer, MaterialIds.scorchedStone, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.scorchedBrick}), 1, 2, folder + "scorched_stone/brick");
        this.materialRecipe(consumer, MaterialIds.scorchedStone, Ingredient.m_204132_(TinkerTags.Items.SCORCHED_BLOCKS), 2, 1, ItemOutput.fromItem(TinkerSmeltery.scorchedBrick), folder + "scorched_stone/block");
        this.metalMaterialRecipe(consumer, MaterialIds.copper, folder, "copper", false);
        this.materialRecipe(consumer, MaterialIds.bloodbone, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.bloodbone}), 1, 1, folder + "bloodbone");
        this.metalMaterialRecipe(consumer, MaterialIds.roseGold, folder, "rose_gold", false);
        this.materialRecipe(consumer, MaterialIds.chain, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50184_}), 1, 1, folder + "chain");
        this.materialRecipe(consumer, MaterialIds.skyslimeVine, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.skySlimeVine}), 1, 1, folder + "skyslime_vine");
        this.materialRecipe(consumer, MaterialIds.greenheart, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.greenheart}), 1, 1, folder + "slimewood/greenheart_planks");
        this.materialRecipe(consumer, MaterialIds.skyroot, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.skyroot}), 1, 1, folder + "slimewood/skyroot_planks");
        this.materialRecipe(consumer, MaterialIds.bloodshroom, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.bloodshroom}), 1, 1, folder + "slimewood/bloodshroom_planks");
        this.materialRecipe(consumer, MaterialIds.greenheart, Ingredient.m_204132_((TagKey)TinkerWorld.greenheart.getLogItemTag()), 4, 1, ItemOutput.fromItem((ItemLike)TinkerWorld.greenheart), folder + "slimewood/greenheart_logs");
        this.materialRecipe(consumer, MaterialIds.skyroot, Ingredient.m_204132_((TagKey)TinkerWorld.skyroot.getLogItemTag()), 4, 1, ItemOutput.fromItem((ItemLike)TinkerWorld.skyroot), folder + "slimewood/skyroot_logs");
        this.materialRecipe(consumer, MaterialIds.bloodshroom, Ingredient.m_204132_((TagKey)TinkerWorld.bloodshroom.getLogItemTag()), 4, 1, ItemOutput.fromItem((ItemLike)TinkerWorld.bloodshroom), folder + "slimewood/bloodshroom_logs");
        this.metalMaterialRecipe(consumer, MaterialIds.slimesteel, folder, "slimesteel", false);
        this.materialRecipe(consumer, MaterialIds.nahuatl, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.nahuatl}), 1, 1, folder + "nahuatl");
        this.metalMaterialRecipe(consumer, MaterialIds.amethystBronze, folder, "amethyst_bronze", false);
        this.metalMaterialRecipe(consumer, MaterialIds.pigIron, folder, "pig_iron", false);
        this.metalMaterialRecipe(consumer, MaterialIds.cobalt, folder, "cobalt", false);
        this.metalMaterialRecipe(consumer, MaterialIds.queensSlime, folder, "queens_slime", false);
        this.metalMaterialRecipe(consumer, MaterialIds.manyullyn, folder, "manyullyn", false);
        this.metalMaterialRecipe(consumer, MaterialIds.hepatizon, folder, "hepatizon", false);
        this.materialRecipe(consumer, MaterialIds.blazingBone, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.blazingBone}), 1, 1, folder + "blazing_bone");
        this.materialRecipe(consumer, MaterialIds.enderslimeVine, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.enderSlimeVine}), 1, 1, folder + "enderslime_vine");
        this.metalMaterialRecipe(consumer, MaterialIds.osmium, folder, "osmium", true);
        this.metalMaterialRecipe(consumer, MaterialIds.tungsten, folder, "tungsten", true);
        this.metalMaterialRecipe(consumer, MaterialIds.platinum, folder, "platinum", true);
        this.metalMaterialRecipe(consumer, MaterialIds.silver, folder, "silver", true);
        this.metalMaterialRecipe(consumer, MaterialIds.lead, folder, "lead", true);
        this.metalMaterialRecipe(consumer, MaterialIds.steel, folder, "steel", true);
        this.metalMaterialRecipe(consumer, MaterialIds.bronze, folder, "bronze", true);
        this.metalMaterialRecipe(consumer, MaterialIds.constantan, folder, "constantan", true);
        this.metalMaterialRecipe(consumer, MaterialIds.invar, folder, "invar", true);
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/uranium")}), MaterialIds.necronium, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerMaterials.necroniumBone}), 1, 1, folder + "necronium");
        this.metalMaterialRecipe(consumer, MaterialIds.electrum, folder, "electrum", true);
        this.metalMaterialRecipe(consumer, MaterialIds.gold, folder, "gold", false);
        this.materialRecipe(consumer, MaterialIds.gunpowder, Ingredient.m_204132_((TagKey)Tags.Items.GUNPOWDER), 1, 2, folder + "gunpowder");
        this.materialRecipe(consumer, MaterialIds.enderPearl, Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS), 1, 1, folder + "ender_pearl");
        this.materialRecipe(consumer, MaterialIds.spider, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), 1, 1, folder + "spider");
        this.materialRecipe(consumer, MaterialIds.venom, (Ingredient)FluidContainerIngredient.fromFluid(TinkerFluids.venom, (boolean)false), 4, 1, folder + "venom_bucket");
        this.materialRecipe(consumer, MaterialIds.rottenFlesh, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_}), 1, 1, folder + "rotten_flesh");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.ENDER)}), 1, 1, folder + "enderslime/ball");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ENDER)}), 4, 1, folder + "enderslime/congealed");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.slime.get((Enum)SlimeType.ENDER)}), 9, 1, folder + "enderslime/block");
        this.materialRecipe(consumer, MaterialIds.phantom, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42714_}), 1, 1, folder + "phantom_membrane");
        this.materialRecipe(consumer, MaterialIds.chorus, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42731_}), 1, 1, folder + "chorus_popped");
        this.materialRecipe(consumer, MaterialIds.rabbit, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42649_}), 1, 1, folder + "rabbit_hide");
    }

    private void addMaterialSmeltery(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.materialMeltingCasting(consumer, MaterialIds.iron, TinkerFluids.moltenIron, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.copper, TinkerFluids.moltenCopper, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.searedStone, TinkerFluids.searedStone, false, 500, folder);
        this.materialMeltingCasting(consumer, MaterialIds.scorchedStone, TinkerFluids.scorchedStone, false, 500, folder);
        this.materialMelting(consumer, MaterialIds.chain, (Fluid)TinkerFluids.moltenIron.get(), 110, folder);
        this.materialComposite(consumer, MaterialIds.rock, MaterialIds.searedStone, TinkerFluids.moltenClay, false, 250, folder);
        this.materialComposite(consumer, MaterialIds.wood, MaterialIds.slimewoodComposite, TinkerFluids.earthSlime, true, 250, folder);
        this.materialComposite(consumer, MaterialIds.flint, MaterialIds.scorchedStone, TinkerFluids.magma, true, 250, folder);
        this.materialComposite(consumer, MaterialIds.bone, MaterialIds.bloodbone, TinkerFluids.blood, false, 250, folder);
        this.materialMeltingCasting(consumer, MaterialIds.slimesteel, TinkerFluids.moltenSlimesteel, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.amethystBronze, TinkerFluids.moltenAmethystBronze, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.roseGold, TinkerFluids.moltenRoseGold, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.pigIron, TinkerFluids.moltenPigIron, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.cobalt, TinkerFluids.moltenCobalt, true, folder);
        this.materialMeltingComposite(consumer, MaterialIds.wood, MaterialIds.nahuatl, TinkerFluids.moltenObsidian, false, 1000, folder);
        this.materialMeltingComposite(consumer, MaterialIds.string, MaterialIds.darkthread, TinkerFluids.moltenObsidian, false, 250, folder);
        this.materialMeltingCasting(consumer, MaterialIds.queensSlime, TinkerFluids.moltenQueensSlime, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.hepatizon, TinkerFluids.moltenHepatizon, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.manyullyn, TinkerFluids.moltenManyullyn, true, folder);
        this.materialComposite(consumer, MaterialIds.necroticBone, MaterialIds.blazingBone, TinkerFluids.blazingBlood, false, 200, folder);
        this.materialMeltingComposite(consumer, MaterialIds.leather, MaterialIds.ancientHide, TinkerFluids.moltenDebris, false, 90, folder);
        this.compatMeltingCasting(consumer, MaterialIds.osmium, TinkerFluids.moltenOsmium, folder);
        this.compatMeltingCasting(consumer, MaterialIds.tungsten, TinkerFluids.moltenTungsten, folder);
        this.compatMeltingCasting(consumer, MaterialIds.platinum, TinkerFluids.moltenPlatinum, folder);
        this.compatMeltingCasting(consumer, MaterialIds.silver, TinkerFluids.moltenSilver, folder);
        this.compatMeltingCasting(consumer, MaterialIds.lead, TinkerFluids.moltenLead, folder);
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/aluminum")}), MaterialIds.rock, MaterialIds.whitestone, TinkerFluids.moltenAluminum, true, 90, folder, "whitestone_from_aluminum");
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/tin")}), MaterialIds.rock, MaterialIds.whitestone, TinkerFluids.moltenTin, true, 90, folder, "whitestone_from_tin");
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/zinc")}), MaterialIds.rock, MaterialIds.whitestone, TinkerFluids.moltenZinc, true, 90, folder, "whitestone_from_zinc");
        this.compatMeltingCasting(consumer, MaterialIds.steel, TinkerFluids.moltenSteel, folder);
        this.compatMeltingCasting(consumer, MaterialIds.constantan, TinkerFluids.moltenConstantan, folder);
        this.compatMeltingCasting(consumer, MaterialIds.invar, TinkerFluids.moltenInvar, folder);
        this.compatMeltingCasting(consumer, MaterialIds.electrum, TinkerFluids.moltenElectrum, folder);
        this.compatMeltingCasting(consumer, MaterialIds.bronze, TinkerFluids.moltenBronze, folder);
        this.materialMeltingComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/uranium")}), MaterialIds.necroticBone, MaterialIds.necronium, TinkerFluids.moltenUranium, true, 90, folder);
        this.materialMeltingComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/brass")}), MaterialIds.slimewood, MaterialIds.platedSlimewood, TinkerFluids.moltenBrass, true, 90, folder);
        this.materialMeltingCasting(consumer, MaterialIds.gold, TinkerFluids.moltenGold, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.enderslime, TinkerFluids.enderSlime, 250, folder);
        this.materialMeltingCasting(consumer, MaterialIds.venom, TinkerFluids.venom, 250, folder);
    }
}

