/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.ISafeManagerReloadListener;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.tools.client.ArmorModelHelper;

public class SlimeskullArmorModel
extends Model {
    private static final SlimeskullArmorModel INSTANCE = new SlimeskullArmorModel();
    public static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> {
        HEAD_MODELS = null;
    };
    @Nullable
    private HumanoidModel<?> base;
    @Nullable
    private ResourceLocation headTexture;
    @Nullable
    private SkullModelBase headModel;
    private boolean hasGlint = false;
    private static final Map<MaterialId, Function<EntityModelSet, ? extends SkullModelBase>> HEAD_MODEL_FACTORIES = new HashMap<MaterialId, Function<EntityModelSet, ? extends SkullModelBase>>();
    private static final Map<MaterialId, ResourceLocation> HEAD_TEXTURES = new HashMap<MaterialId, ResourceLocation>();
    private static Map<MaterialId, SkullModelBase> HEAD_MODELS;

    public static Model getModel(ItemStack stack, HumanoidModel<?> baseModel) {
        INSTANCE.setup(baseModel, stack);
        return INSTANCE;
    }

    private SlimeskullArmorModel() {
        super(RenderType::m_110458_);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, this.base.f_102610_ ? -0.015 : -0.02, 0.0);
            matrixStackIn.m_85841_(1.01f, 1.0f, 1.01f);
            this.base.m_7695_(matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStackIn.m_85849_();
            if (this.headModel != null && this.headTexture != null && ArmorModelHelper.buffer != null) {
                boolean needsPush;
                VertexConsumer headBuilder = ItemRenderer.m_115184_((MultiBufferSource)ArmorModelHelper.buffer, (RenderType)RenderType.m_110464_((ResourceLocation)this.headTexture), (boolean)false, (boolean)this.hasGlint);
                boolean bl = needsPush = this.base.f_102610_ || this.base.f_102817_;
                if (needsPush) {
                    matrixStackIn.m_85836_();
                    if (this.base.f_102610_) {
                        matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
                        matrixStackIn.m_85837_(0.0, 1.0, 0.0);
                    }
                    if (this.base.f_102817_) {
                        matrixStackIn.m_85837_(0.0, (double)(this.base.f_102808_.f_104201_ / 16.0f), 0.0);
                    }
                }
                this.headModel.m_142698_(0.0f, this.base.f_102808_.f_104204_ * 180.0f / (float)Math.PI, this.base.f_102808_.f_104203_ * 180.0f / (float)Math.PI);
                this.headModel.m_7695_(matrixStackIn, headBuilder, packedLightIn, packedOverlayIn, red, green * 0.5f, blue, alpha * 0.8f);
                if (needsPush) {
                    matrixStackIn.m_85849_();
                }
            }
        }
    }

    private void setup(HumanoidModel<?> base, ItemStack stack) {
        this.base = base;
        this.hasGlint = stack.m_41790_();
        MaterialId materialId = MaterialIdNBT.from(stack).getMaterial(0).getId();
        if (!materialId.equals(IMaterial.UNKNOWN_ID)) {
            SkullModelBase model = SlimeskullArmorModel.getHeadModel(materialId);
            ResourceLocation texture = HEAD_TEXTURES.get(materialId);
            if (model != null && texture != null) {
                this.headModel = model;
                this.headTexture = texture;
                return;
            }
        }
        this.headTexture = null;
        this.headModel = null;
    }

    public static void registerHeadModel(MaterialId materialId, ModelLayerLocation headModel, ResourceLocation texture) {
        SlimeskullArmorModel.registerHeadModel(materialId, (EntityModelSet modelSet) -> new SkullModel(modelSet.m_171103_(headModel)), texture);
    }

    public static void registerHeadModel(MaterialId materialId, Function<EntityModelSet, ? extends SkullModelBase> headFunction, ResourceLocation texture) {
        if (HEAD_MODEL_FACTORIES.containsKey(materialId)) {
            throw new IllegalArgumentException("Duplicate head model " + materialId);
        }
        HEAD_MODEL_FACTORIES.put(materialId, headFunction);
        HEAD_TEXTURES.put(materialId, texture);
    }

    @Nullable
    private static SkullModelBase getHeadModel(MaterialId materialId) {
        if (HEAD_MODELS == null) {
            EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
            ImmutableMap.Builder models = ImmutableMap.builder();
            for (Map.Entry<MaterialId, Function<EntityModelSet, ? extends SkullModelBase>> entry : HEAD_MODEL_FACTORIES.entrySet()) {
                models.put((Object)entry.getKey(), (Object)entry.getValue().apply(modelSet));
            }
            HEAD_MODELS = models.build();
        }
        return HEAD_MODELS.get(materialId);
    }
}

