/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.function.Supplier;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.util.SupplierCreativeTab;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.json.AddToolDataFunction;
import slimeknights.tconstruct.library.json.RandomMaterial;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolPredicate;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.aoe.BoxAOEIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.CircleAOEIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.FallbackAOEIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.TreeAOEIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.VeiningAOEIterator;
import slimeknights.tconstruct.library.tools.definition.harvest.FixedTierHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.harvest.ModifiedHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.harvest.TagHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.weapon.CircleWeaponAttack;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.definition.weapon.ParticleWeaponAttack;
import slimeknights.tconstruct.library.tools.definition.weapon.SweepWeaponAttack;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.tools.ArmorDefinitions;
import slimeknights.tconstruct.tools.ToolDefinitions;
import slimeknights.tconstruct.tools.data.StationSlotLayoutProvider;
import slimeknights.tconstruct.tools.data.ToolDefinitionDataProvider;
import slimeknights.tconstruct.tools.data.ToolsRecipeProvider;
import slimeknights.tconstruct.tools.data.material.MaterialDataProvider;
import slimeknights.tconstruct.tools.data.material.MaterialRecipeProvider;
import slimeknights.tconstruct.tools.data.material.MaterialRenderInfoProvider;
import slimeknights.tconstruct.tools.data.material.MaterialStatsDataProvider;
import slimeknights.tconstruct.tools.data.material.MaterialTraitsDataProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerMaterialSpriteProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerPartSpriteProvider;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.ModifiableSwordItem;
import slimeknights.tconstruct.tools.item.PlateArmorItem;
import slimeknights.tconstruct.tools.item.SlimelytraItem;
import slimeknights.tconstruct.tools.item.SlimeskullItem;
import slimeknights.tconstruct.tools.item.SlimesuitItem;
import slimeknights.tconstruct.tools.item.TravelersGearItem;
import slimeknights.tconstruct.tools.logic.EquipmentChangeWatcher;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public final class TinkerTools
extends TinkerModule {
    public static final CreativeModeTab TAB_TOOLS = new SupplierCreativeTab("tconstruct", "tools", () -> ((ModifiableItem)pickaxe.get()).getRenderTool());
    public static LootItemFunctionType lootAddToolData;
    private static final Item.Properties TOOL;
    public static final ItemObject<ModifiableItem> pickaxe;
    public static final ItemObject<ModifiableItem> sledgeHammer;
    public static final ItemObject<ModifiableItem> veinHammer;
    public static final ItemObject<ModifiableItem> mattock;
    public static final ItemObject<ModifiableItem> pickadze;
    public static final ItemObject<ModifiableItem> excavator;
    public static final ItemObject<ModifiableItem> handAxe;
    public static final ItemObject<ModifiableItem> broadAxe;
    public static final ItemObject<ModifiableItem> kama;
    public static final ItemObject<ModifiableItem> scythe;
    public static final ItemObject<ModifiableItem> dagger;
    public static final ItemObject<ModifiableItem> sword;
    public static final ItemObject<ModifiableItem> cleaver;
    public static final ItemObject<ModifiableItem> flintAndBrick;
    public static final EnumObject<ArmorSlotType, ModifiableArmorItem> travelersGear;
    public static final EnumObject<ArmorSlotType, ModifiableArmorItem> plateArmor;
    public static final EnumObject<ArmorSlotType, ModifiableArmorItem> slimesuit;
    public static final RegistryObject<SimpleParticleType> hammerAttackParticle;
    public static final RegistryObject<SimpleParticleType> axeAttackParticle;
    public static final RegistryObject<EntityType<IndestructibleItemEntity>> indestructibleItem;
    public static final RegistryObject<MenuType<ToolContainerMenu>> toolContainer;

    public TinkerTools() {
        SlotType.init();
        BlockSideHitListener.init();
        ModifierLootingHandler.init();
        RandomMaterial.init();
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        EquipmentChangeWatcher.register();
        ToolCapabilityProvider.register(ToolFluidCapability.Provider::new);
        ToolCapabilityProvider.register(ToolInventoryCapability.Provider::new);
    }

    @SubscribeEvent
    void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        ItemPredicate.register((ResourceLocation)ToolPredicate.ID, ToolPredicate::deserialize);
        lootAddToolData = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)AddToolDataFunction.ID, (Object)new LootItemFunctionType((Serializer)AddToolDataFunction.SERIALIZER));
        IHarvestLogic.LOADER.register(TConstruct.getResource("effective_tag"), (GenericLoaderRegistry.IGenericLoader)TagHarvestLogic.LOADER);
        IHarvestLogic.LOADER.register(TConstruct.getResource("modified_tag"), (GenericLoaderRegistry.IGenericLoader)ModifiedHarvestLogic.LOADER);
        IHarvestLogic.LOADER.register(TConstruct.getResource("fixed_tier"), (GenericLoaderRegistry.IGenericLoader)FixedTierHarvestLogic.LOADER);
        IAreaOfEffectIterator.LOADER.register(TConstruct.getResource("box"), (GenericLoaderRegistry.IGenericLoader)BoxAOEIterator.LOADER);
        IAreaOfEffectIterator.LOADER.register(TConstruct.getResource("circle"), (GenericLoaderRegistry.IGenericLoader)CircleAOEIterator.LOADER);
        IAreaOfEffectIterator.LOADER.register(TConstruct.getResource("tree"), (GenericLoaderRegistry.IGenericLoader)TreeAOEIterator.LOADER);
        IAreaOfEffectIterator.LOADER.register(TConstruct.getResource("vein"), (GenericLoaderRegistry.IGenericLoader)VeiningAOEIterator.LOADER);
        IAreaOfEffectIterator.LOADER.register(TConstruct.getResource("fallback"), (GenericLoaderRegistry.IGenericLoader)FallbackAOEIterator.LOADER);
        IWeaponAttack.LOADER.register(TConstruct.getResource("sweep"), (GenericLoaderRegistry.IGenericLoader)SweepWeaponAttack.LOADER);
        IWeaponAttack.LOADER.register(TConstruct.getResource("circle"), (GenericLoaderRegistry.IGenericLoader)CircleWeaponAttack.LOADER);
        IWeaponAttack.LOADER.register(TConstruct.getResource("particle"), (GenericLoaderRegistry.IGenericLoader)ParticleWeaponAttack.LOADER);
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new ToolsRecipeProvider(generator));
            generator.m_123914_((DataProvider)new MaterialRecipeProvider(generator));
            MaterialDataProvider materials = new MaterialDataProvider(generator);
            generator.m_123914_((DataProvider)materials);
            generator.m_123914_((DataProvider)new MaterialStatsDataProvider(generator, materials));
            generator.m_123914_((DataProvider)new MaterialTraitsDataProvider(generator, materials));
            generator.m_123914_((DataProvider)new ToolDefinitionDataProvider(generator));
            generator.m_123914_((DataProvider)new StationSlotLayoutProvider(generator));
        }
        if (event.includeClient()) {
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            TinkerMaterialSpriteProvider materialSprites = new TinkerMaterialSpriteProvider();
            TinkerPartSpriteProvider partSprites = new TinkerPartSpriteProvider();
            generator.m_123914_((DataProvider)new MaterialRenderInfoProvider(generator, materialSprites));
            generator.m_123914_((DataProvider)new GeneratorPartTextureJsonGenerator(generator, "tconstruct", partSprites));
            generator.m_123914_((DataProvider)new MaterialPartTextureGenerator(generator, existingFileHelper, partSprites, materialSprites));
        }
    }

    static {
        TOOL = new Item.Properties().m_41487_(1).m_41491_(TAB_TOOLS);
        pickaxe = ITEMS.register("pickaxe", () -> new ModifiableItem(TOOL, ToolDefinitions.PICKAXE));
        sledgeHammer = ITEMS.register("sledge_hammer", () -> new ModifiableItem(TOOL, ToolDefinitions.SLEDGE_HAMMER));
        veinHammer = ITEMS.register("vein_hammer", () -> new ModifiableItem(TOOL, ToolDefinitions.VEIN_HAMMER));
        mattock = ITEMS.register("mattock", () -> new ModifiableItem(TOOL, ToolDefinitions.MATTOCK));
        pickadze = ITEMS.register("pickadze", () -> new ModifiableItem(TOOL, ToolDefinitions.PICKADZE));
        excavator = ITEMS.register("excavator", () -> new ModifiableItem(TOOL, ToolDefinitions.EXCAVATOR));
        handAxe = ITEMS.register("hand_axe", () -> new ModifiableItem(TOOL, ToolDefinitions.HAND_AXE));
        broadAxe = ITEMS.register("broad_axe", () -> new ModifiableItem(TOOL, ToolDefinitions.BROAD_AXE));
        kama = ITEMS.register("kama", () -> new ModifiableItem(TOOL, ToolDefinitions.KAMA));
        scythe = ITEMS.register("scythe", () -> new ModifiableItem(TOOL, ToolDefinitions.SCYTHE));
        dagger = ITEMS.register("dagger", () -> new ModifiableSwordItem(TOOL, ToolDefinitions.DAGGER));
        sword = ITEMS.register("sword", () -> new ModifiableSwordItem(TOOL, ToolDefinitions.SWORD));
        cleaver = ITEMS.register("cleaver", () -> new ModifiableSwordItem(TOOL, ToolDefinitions.CLEAVER));
        flintAndBrick = ITEMS.register("flint_and_brick", () -> new ModifiableItem(TOOL, ToolDefinitions.FLINT_AND_BRICK));
        travelersGear = ITEMS.registerEnum("travelers", ArmorSlotType.values(), type -> new TravelersGearItem(ArmorDefinitions.TRAVELERS, (ArmorSlotType)((Object)type), TOOL));
        plateArmor = ITEMS.registerEnum("plate", ArmorSlotType.values(), type -> new PlateArmorItem(ArmorDefinitions.PLATE, (ArmorSlotType)((Object)type), TOOL));
        slimesuit = new EnumObject.Builder(ArmorSlotType.class).putAll(ITEMS.registerEnum("slime", new ArmorSlotType[]{ArmorSlotType.BOOTS, ArmorSlotType.LEGGINGS}, type -> new SlimesuitItem(ArmorDefinitions.SLIMESUIT, (ArmorSlotType)((Object)type), TOOL))).put((Enum)ArmorSlotType.CHESTPLATE, (Supplier)ITEMS.register("slime_chestplate", () -> new SlimelytraItem(ArmorDefinitions.SLIMESUIT, TOOL))).put((Enum)ArmorSlotType.HELMET, (Supplier)ITEMS.register("slime_helmet", () -> new SlimeskullItem(ArmorDefinitions.SLIMESUIT, TOOL))).build();
        hammerAttackParticle = PARTICLE_TYPES.register("hammer_attack", () -> new SimpleParticleType(true));
        axeAttackParticle = PARTICLE_TYPES.register("axe_attack", () -> new SimpleParticleType(true));
        indestructibleItem = ENTITIES.register("indestructible_item", () -> EntityType.Builder.m_20704_(IndestructibleItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20719_());
        toolContainer = MENUS.register("tool_container", ToolContainerMenu::forClient);
    }
}

