/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.inventory;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.tables.block.entity.table.PartBuilderBlockEntity;

public class PartBuilderContainerWrapper
implements IPartBuilderContainer {
    private final PartBuilderBlockEntity builder;
    private boolean materialNeedsUpdate = true;
    @Nullable
    private MaterialRecipe material = null;

    public PartBuilderContainerWrapper(PartBuilderBlockEntity builder) {
        this.builder = builder;
    }

    public ItemStack getStack() {
        return this.builder.m_8020_(0);
    }

    @Override
    public ItemStack getPatternStack() {
        return this.builder.m_8020_(1);
    }

    protected Level getWorld() {
        return Objects.requireNonNull(this.builder.m_58904_(), "Tile entity world must be nonnull");
    }

    public void refreshMaterial() {
        this.materialNeedsUpdate = true;
        this.material = null;
    }

    @Override
    @Nullable
    public MaterialRecipe getMaterial() {
        if (this.materialNeedsUpdate) {
            this.materialNeedsUpdate = false;
            if (this.getStack().m_41619_()) {
                this.material = null;
            } else {
                Level world = this.getWorld();
                this.material = world.m_7465_().m_44015_((RecipeType)TinkerRecipeTypes.MATERIAL.get(), (Container)this, world).orElse(null);
            }
        }
        return this.material;
    }
}

