/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.smeltery.block.entity.controller.MelterBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiTankModule;
import slimeknights.tconstruct.smeltery.menu.MelterContainerMenu;

public class MelterScreen
extends AbstractContainerScreen<MelterContainerMenu>
implements IScreenWithFluidTank {
    private static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/melter.png");
    private static final ElementScreen SCALA = new ElementScreen(176, 0, 52, 52, 256, 256);
    private static final ElementScreen FUEL_SLOT = new ElementScreen(176, 52, 18, 36, 256, 256);
    private static final ElementScreen FUEL_TANK = new ElementScreen(194, 52, 14, 38, 256, 256);
    private final GuiMeltingModule melting;
    private final GuiFuelModule fuel;
    private final GuiTankModule tank;

    public MelterScreen(MelterContainerMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        MelterBlockEntity te = (MelterBlockEntity)container.getTile();
        if (te != null) {
            FuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule(this, te.getMeltingInventory(), fuelModule::getTemperature, slot -> true);
            this.fuel = new GuiFuelModule(this, fuelModule, 153, 32, 12, 36, 152, 15, container.isHasFuelSlot());
            this.tank = new GuiTankModule(this, (IFluidHandler)te.getTank(), 90, 16, 52, 52);
        } else {
            this.melting = null;
            this.fuel = null;
            this.tank = null;
        }
    }

    public void m_6305_(PoseStack matrices, int x, int y, float partialTicks) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, x, y, partialTicks);
        this.m_7025_(matrices, x, y);
    }

    protected void m_7286_(PoseStack matrices, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(matrices, this, BACKGROUND);
        if (this.fuel != null) {
            if (((MelterContainerMenu)this.f_97732_).isHasFuelSlot()) {
                FUEL_SLOT.draw(matrices, this.f_97735_ + 150, this.f_97736_ + 31);
            } else {
                FUEL_TANK.draw(matrices, this.f_97735_ + 152, this.f_97736_ + 31);
            }
            this.fuel.draw(matrices);
        }
        if (this.tank != null) {
            this.tank.draw(matrices);
        }
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        super.m_7027_(matrices, mouseX, mouseY);
        int checkX = mouseX - this.f_97735_;
        int checkY = mouseY - this.f_97736_;
        if (this.tank != null) {
            this.tank.highlightHoveredFluid(matrices, checkX, checkY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(matrices, checkX, checkY);
        }
        RenderUtils.setup(BACKGROUND);
        SCALA.draw(matrices, 90, 16);
        if (this.melting != null) {
            this.melting.drawHeatBars(matrices);
        }
    }

    protected void m_7025_(PoseStack matrices, int mouseX, int mouseY) {
        super.m_7025_(matrices, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderTooltip(matrices, mouseX, mouseY);
        }
        if (this.melting != null) {
            this.melting.drawHeatTooltips(matrices, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.addTooltip(matrices, mouseX, mouseY, true);
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        FluidStack ingredient = null;
        int checkX = (int)mouseX - this.f_97735_;
        int checkY = (int)mouseY - this.f_97736_;
        if (this.fuel != null) {
            ingredient = this.fuel.getIngredient(checkX, checkY);
        }
        if (this.tank != null && ingredient == null) {
            ingredient = this.tank.getIngreientUnderMouse(checkX, checkY);
        }
        return ingredient;
    }
}

