/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.util.TablePrinter;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.shared.command.argument.SlotTypeArgument;

public class ModifierUsageCommand {
    private static final Component SUCCESS = new TranslatableComponent("command.tconstruct.modifier_usage");

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSourceStack>)context, ModifierUsages.ALL, null))).then(Commands.m_82127_((String)"all").executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSourceStack>)context, ModifierUsages.ALL, null)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"recipe").then(Commands.m_82129_((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType()).executes(ModifierUsageCommand::runRecipeWithFilter))).executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSourceStack>)context, ModifierUsages.RECIPE, null)))).then(Commands.m_82127_((String)"material_trait").executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSourceStack>)context, ModifierUsages.MATERIAL_TRAIT, null)))).then(Commands.m_82127_((String)"tool_trait").executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSourceStack>)context, ModifierUsages.TOOL_TRAIT, null)))).then(Commands.m_82127_((String)"unused").executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSourceStack>)context, ModifierUsages.UNUSED, null)));
    }

    private static int runRecipeWithFilter(CommandContext<CommandSourceStack> context) {
        return ModifierUsageCommand.runForType(context, ModifierUsages.RECIPE, SlotTypeArgument.getOptional(context, "slot_type"));
    }

    private static int runForType(CommandContext<CommandSourceStack> context, ModifierUsages filter, @Nullable SlotTypeArgument.OptionalSlotType slotFilter) {
        HashMultimap recipeModifiers = ((CommandSourceStack)context.getSource()).m_81372_().m_7465_().m_44054_((RecipeType)TinkerRecipeTypes.TINKER_STATION.get()).values().stream().filter(r -> r instanceof IModifierRecipe).map(r -> (IModifierRecipe)r).collect(Collector.of(HashMultimap::create, (map, r) -> map.put((Object)r.getSlotType(), (Object)r.getModifier()), (m1, m2) -> {
            m1.putAll((Multimap)m2);
            return m1;
        }, new Collector.Characteristics[0]));
        IMaterialRegistry matReg = MaterialRegistry.getInstance();
        Set materialTraits = matReg.getAllMaterials().stream().flatMap(mat -> {
            MaterialId matId = mat.getIdentifier();
            return Stream.concat(matReg.getDefaultTraits(matId).stream(), matReg.getAllStats(matId).stream().filter(stat -> matReg.hasUniqueTraits(matId, stat.getIdentifier())).flatMap(stat -> matReg.getTraits(matId, stat.getIdentifier()).stream()));
        }).map(ModifierEntry::getModifier).collect(Collectors.toSet());
        Set toolTraits = RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, TinkerTags.Items.MODIFIABLE).filter(item -> item instanceof IModifiable).flatMap(item -> ((IModifiable)item).getToolDefinition().getData().getTraits().stream()).map(ModifierEntry::getModifier).collect(Collectors.toSet());
        Stream<Object> modifierStream = switch (filter) {
            case ModifierUsages.RECIPE -> {
                if (slotFilter != null) {
                    yield recipeModifiers.get((Object)slotFilter.slotType()).stream();
                }
                yield recipeModifiers.values().stream();
            }
            case ModifierUsages.MATERIAL_TRAIT -> materialTraits.stream();
            case ModifierUsages.TOOL_TRAIT -> toolTraits.stream();
            default -> ModifierManager.INSTANCE.getAllValues();
        };
        if (filter == ModifierUsages.UNUSED) {
            modifierStream = modifierStream.filter(modifier -> !recipeModifiers.containsValue(modifier) && !materialTraits.contains(modifier) && !toolTraits.contains(modifier));
        }
        TablePrinter table = new TablePrinter();
        table.header("ID", r -> r.modifierId().toString());
        if (filter != ModifierUsages.UNUSED) {
            if (filter != ModifierUsages.RECIPE || slotFilter == null) {
                table.header("Recipe", ModifierUsageRow::recipe);
            }
            if (filter != ModifierUsages.MATERIAL_TRAIT) {
                table.header("material Trait", r -> r.materialTrait() ? "Material trait" : "");
            }
            if (filter != ModifierUsages.TOOL_TRAIT) {
                table.header("tool Trait", r -> r.toolTrait() ? "Tool trait" : "");
            }
        }
        StringBuilder logOutput = new StringBuilder();
        logOutput.append(filter.logPrefix);
        if (slotFilter != null) {
            if (slotFilter.slotType() == null) {
                logOutput.append(" (slotless)");
            } else {
                logOutput.append(" (").append(slotFilter.slotType().getName()).append(")");
            }
        }
        logOutput.append(System.lineSeparator());
        List<Modifier> finalList = modifierStream.sorted(Comparator.comparing(Modifier::getId)).toList();
        finalList.forEach(modifier -> {
            List recipeUsages = SlotType.getAllSlotTypes().stream().filter(type -> recipeModifiers.containsEntry(type, modifier)).map(SlotType::getName).collect(Collectors.toList());
            String recipes = recipeUsages.isEmpty() ? (recipeModifiers.containsEntry(null, modifier) ? "slotless" : "") : String.join((CharSequence)", ", recipeUsages);
            table.add((Object)new ModifierUsageRow(modifier.getId(), recipes, toolTraits.contains(modifier), materialTraits.contains(modifier)));
        });
        table.build(logOutput);
        TConstruct.LOG.info(logOutput.toString());
        ((CommandSourceStack)context.getSource()).m_81354_(SUCCESS, true);
        return finalList.size();
    }

    private static enum ModifierUsages {
        UNUSED("Unused modifiers:"),
        RECIPE("Recipe modifiers:"),
        MATERIAL_TRAIT("Material trait modifiers:"),
        TOOL_TRAIT("Tool trait modifiers:"),
        ALL("All modifiers:");

        private final String logPrefix;

        private ModifierUsages(String logPrefix) {
            this.logPrefix = logPrefix;
        }
    }

    private record ModifierUsageRow(ModifierId modifierId, String recipe, boolean toolTrait, boolean materialTrait) {
    }
}

