/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.fluid.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingCategory
extends AbstractMeltingCategory {
    private static final Component TITLE = TConstruct.makeTranslation("jei", "melting.title");
    private static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    private static final String KEY_MULTIPLIER = TConstruct.makeTranslationKey("jei", "melting.multiplier");
    private static final Component SOLID_TEMPERATURE = new TranslatableComponent(KEY_TEMPERATURE, new Object[]{800}).m_130940_(ChatFormatting.GRAY);
    private static final Component SOLID_MULTIPLIER = new TranslatableComponent(KEY_MULTIPLIER, new Object[]{Float.valueOf(0.8f)}).m_130940_(ChatFormatting.GRAY);
    private static final Component TOOLTIP_SMELTERY = TConstruct.makeTranslation("jei", "melting.smeltery").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.UNDERLINE});
    private static final Component TOOLTIP_MELTER = TConstruct.makeTranslation("jei", "melting.melter").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.UNDERLINE});
    private static final IRecipeSlotTooltipCallback ITEM_FUEL_TOOLTIP = (slot, list) -> {
        list.add(1, SOLID_TEMPERATURE);
        list.add(2, SOLID_MULTIPLIER);
    };
    private static final IRecipeSlotTooltipCallback METAL_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.METAL);
    private static final IRecipeSlotTooltipCallback GEM_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.GEM);
    private final IDrawable icon;
    private final IDrawableStatic solidFuel;

    public MeltingCategory(IGuiHelper helper) {
        super(helper);
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack(TinkerSmeltery.searedMelter));
        this.solidFuel = helper.drawableBuilder(BACKGROUND_LOC, 164, 0, 18, 20).build();
    }

    public ResourceLocation getUid() {
        return TConstructJEIConstants.MELTING.getUid();
    }

    public RecipeType<MeltingRecipe> getRecipeType() {
        return TConstructJEIConstants.MELTING;
    }

    public Component getTitle() {
        return TITLE;
    }

    @Override
    public void draw(MeltingRecipe recipe, IRecipeSlotsView slots, PoseStack matrices, double mouseX, double mouseY) {
        super.draw(recipe, slots, matrices, mouseX, mouseY);
        int temperature = recipe.getTemperature();
        if (temperature <= 800) {
            this.solidFuel.draw(matrices, 1, 19);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MeltingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 18).addIngredients(recipe.getInput());
        IMeltingContainer.OreRateType oreType = recipe.getOreType();
        Object tooltip = oreType == IMeltingContainer.OreRateType.METAL ? METAL_ORE_TOOLTIP : (oreType == IMeltingContainer.OreRateType.GEM ? GEM_ORE_TOOLTIP : MeltingFluidCallback.INSTANCE);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 4).addTooltipCallback(tooltip).setFluidRenderer(810, false, 32, 32).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredient(VanillaTypes.FLUID, (Object)recipe.getOutput());
        int fuelHeight = 32;
        if (recipe.getTemperature() <= 800) {
            fuelHeight = 15;
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 2, 22).addTooltipCallback(ITEM_FUEL_TOOLTIP).addItemStacks((List)MeltingFuelHandler.SOLID_FUELS.get());
        }
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 4, 4).addTooltipCallback((IRecipeSlotTooltipCallback)FUEL_TOOLTIP).setFluidRenderer(1, false, 12, fuelHeight).addIngredients(VanillaTypes.FLUID, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private static class MeltingFluidCallback
    extends AbstractMeltingCategory.MeltingFluidCallback {
        private final IMeltingContainer.OreRateType oreType;

        @Override
        protected boolean appendMaterial(FluidStack stack, List<Component> list) {
            int melterAmount;
            Fluid fluid = stack.getFluid();
            int amount = stack.getAmount();
            int smelteryAmount = Config.COMMON.smelteryOreRate.applyOreBoost(this.oreType, amount);
            if (smelteryAmount != (melterAmount = Config.COMMON.melterOreRate.applyOreBoost(this.oreType, amount))) {
                list.add(TOOLTIP_MELTER);
                boolean shift = FluidTooltipHandler.appendMaterialNoShift(fluid, melterAmount, list);
                list.add(TextComponent.f_131282_);
                list.add(TOOLTIP_SMELTERY);
                shift = FluidTooltipHandler.appendMaterialNoShift(fluid, smelteryAmount, list) || shift;
                return shift;
            }
            return FluidTooltipHandler.appendMaterialNoShift(fluid, smelteryAmount, list);
        }

        public MeltingFluidCallback(IMeltingContainer.OreRateType oreType) {
            this.oreType = oreType;
        }

        public IMeltingContainer.OreRateType getOreType() {
            return this.oreType;
        }
    }
}

