/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.casting;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.fluid.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.plugin.jei.IRecipeTooltipReplacement;

public abstract class AbstractCastingCategory
implements IRecipeCategory<IDisplayableCastingRecipe>,
IRecipeTooltipReplacement {
    private static final String KEY_COOLING_TIME = TConstruct.makeTranslationKey("jei", "time");
    private static final String KEY_CAST_KEPT = TConstruct.makeTranslationKey("jei", "casting.cast_kept");
    private static final String KEY_CAST_CONSUMED = TConstruct.makeTranslationKey("jei", "casting.cast_consumed");
    protected static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/casting.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable tankOverlay;
    private final IDrawable castConsumed;
    private final IDrawable castKept;
    private final IDrawable block;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    protected AbstractCastingCategory(final IGuiHelper guiHelper, Block icon, IDrawable block) {
        this.background = guiHelper.createDrawable(BACKGROUND_LOC, 0, 0, 117, 54);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)icon));
        this.tankOverlay = guiHelper.createDrawable(BACKGROUND_LOC, 133, 0, 32, 32);
        this.castConsumed = guiHelper.createDrawable(BACKGROUND_LOC, 141, 32, 13, 11);
        this.castKept = guiHelper.createDrawable(BACKGROUND_LOC, 141, 43, 13, 11);
        this.block = block;
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer coolingTime) {
                return guiHelper.drawableBuilder(BACKGROUND_LOC, 117, 32, 24, 17).buildAnimated(coolingTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public boolean isHandled(IDisplayableCastingRecipe recipe) {
        return true;
    }

    public Class<? extends IDisplayableCastingRecipe> getRecipeClass() {
        return IDisplayableCastingRecipe.class;
    }

    public void draw(IDisplayableCastingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        ((IDrawableAnimated)this.cachedArrows.getUnchecked((Object)Math.max(1, recipe.getCoolingTime()))).draw(matrixStack, 58, 18);
        this.block.draw(matrixStack, 38, 35);
        if (recipe.hasCast()) {
            (recipe.isConsumed() ? this.castConsumed : this.castKept).draw(matrixStack, 63, 39);
        }
        int coolingTime = recipe.getCoolingTime() / 20;
        String coolingString = I18n.m_118938_((String)KEY_COOLING_TIME, (Object[])new Object[]{coolingTime});
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int x = 72 - fontRenderer.m_92895_(coolingString) / 2;
        fontRenderer.m_92883_(matrixStack, coolingString, (float)x, 2.0f, Color.GRAY.getRGB());
    }

    public List<Component> getTooltipStrings(IDisplayableCastingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (recipe.hasCast() && GuiUtil.isHovered((int)mouseX, (int)mouseY, 63, 39, 13, 11)) {
            return Collections.singletonList(new TranslatableComponent(recipe.isConsumed() ? KEY_CAST_CONSUMED : KEY_CAST_KEPT));
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IDisplayableCastingRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> casts = recipe.getCastItems();
        if (!casts.isEmpty()) {
            builder.addSlot(recipe.isConsumed() ? RecipeIngredientRole.INPUT : RecipeIngredientRole.CATALYST, 38, 19).addItemStacks(casts);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 18).addItemStack(recipe.getOutput());
        int capacity = 810;
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).addTooltipCallback((IRecipeSlotTooltipCallback)this).setFluidRenderer(capacity, false, 32, 32).setOverlay(this.tankOverlay, 0, 0).addIngredients(VanillaTypes.FLUID, recipe.getFluids());
        int h = 11;
        if (!recipe.hasCast()) {
            h += 16;
        }
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 43, 8).addTooltipCallback((IRecipeSlotTooltipCallback)this).setFluidRenderer(1, false, 6, h).addIngredients(VanillaTypes.FLUID, recipe.getFluids());
    }

    @Override
    public void addMiddleLines(IRecipeSlotView slot, List<Component> list) {
        slot.getDisplayedIngredient(VanillaTypes.FLUID).ifPresent(stack -> FluidTooltipHandler.appendMaterial(stack, list));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

