/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.fluid.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.plugin.jei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipeCategory
implements IRecipeCategory<AlloyRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/alloy.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "alloy.title");
    private static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    private static final IRecipeTooltipReplacement FLUID_TOOLTIP = (slot, list) -> slot.getDisplayedIngredient(VanillaTypes.FLUID).ifPresent(stack -> FluidTooltipHandler.appendMaterial(stack, list));
    public static final IRecipeTooltipReplacement FUEL_TOOLTIP = (slot, tooltip) -> slot.getDisplayedIngredient(VanillaTypes.FLUID).ifPresent(stack -> MeltingFuelHandler.getTemperature(stack.getFluid()).ifPresent(temperature -> tooltip.add(new TranslatableComponent(KEY_TEMPERATURE, new Object[]{temperature}).m_130940_(ChatFormatting.GRAY))));
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable tank;

    public AlloyRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 172, 62);
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack(TinkerSmeltery.smelteryController));
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 172, 0, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tank = helper.createDrawable(BACKGROUND_LOC, 172, 17, 16, 16);
    }

    public ResourceLocation getUid() {
        return TConstructJEIConstants.ALLOY.getUid();
    }

    public Class<? extends AlloyRecipe> getRecipeClass() {
        return AlloyRecipe.class;
    }

    public RecipeType<AlloyRecipe> getRecipeType() {
        return TConstructJEIConstants.ALLOY;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void draw(AlloyRecipe recipe, IRecipeSlotsView slots, PoseStack matrices, double mouseX, double mouseY) {
        this.arrow.draw(matrices, 90, 21);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        String tempString = I18n.m_118938_((String)KEY_TEMPERATURE, (Object[])new Object[]{recipe.getTemperature()});
        int x = 102 - fontRenderer.m_92895_(tempString) / 2;
        fontRenderer.m_92883_(matrices, tempString, (float)x, 5.0f, Color.GRAY.getRGB());
    }

    public static int drawVariableFluids(IRecipeLayoutBuilder builder, RecipeIngredientRole role, int x, int y, int totalWidth, int height, List<List<FluidStack>> fluids, int minAmount, IRecipeSlotTooltipCallback tooltip) {
        int count = fluids.size();
        int maxAmount = minAmount;
        if (count > 0) {
            for (List<FluidStack> list : fluids) {
                for (FluidStack input : list) {
                    if (input.getAmount() <= maxAmount) continue;
                    maxAmount = input.getAmount();
                }
            }
            int w = totalWidth / count;
            int max = count - 1;
            for (int i = 0; i < max; ++i) {
                int fluidX = x + i * w;
                builder.addSlot(role, fluidX, y).addTooltipCallback(tooltip).setFluidRenderer(maxAmount, false, w, height).addIngredients(VanillaTypes.FLUID, fluids.get(i));
            }
            int fluidX = x + max * w;
            builder.addSlot(role, fluidX, y).addTooltipCallback(tooltip).setFluidRenderer(maxAmount, false, totalWidth - w * max, height).addIngredients(VanillaTypes.FLUID, fluids.get(max));
        }
        return maxAmount;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloyRecipe recipe, IFocusGroup focuses) {
        int maxAmount = AlloyRecipeCategory.drawVariableFluids(builder, RecipeIngredientRole.INPUT, 19, 11, 48, 32, recipe.getDisplayInputs(), recipe.getOutput().getAmount(), FLUID_TOOLTIP);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 137, 11).addTooltipCallback((IRecipeSlotTooltipCallback)FLUID_TOOLTIP).setFluidRenderer(maxAmount, false, 16, 32).addIngredient(VanillaTypes.FLUID, (Object)recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 94, 43).addTooltipCallback((IRecipeSlotTooltipCallback)FUEL_TOOLTIP).setFluidRenderer(1, false, 16, 16).setOverlay(this.tank, 0, 0).addIngredients(VanillaTypes.FLUID, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

