/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.weapon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ParticleWeaponAttack
implements IWeaponAttack {
    public static final Loader LOADER = new Loader();
    private final SimpleParticleType particle;

    @Override
    public boolean dealDamage(IToolStackView tool, ToolAttackContext context, float damage) {
        boolean hit = ToolAttackUtil.dealDefaultDamage(context.getAttacker(), context.getTarget(), damage);
        if (hit && context.isFullyCharged()) {
            ToolAttackUtil.spawnAttackParticle((ParticleOptions)this.particle, (Entity)context.getAttacker(), 0.8);
        }
        return hit;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IWeaponAttack> getLoader() {
        return LOADER;
    }

    public ParticleWeaponAttack(SimpleParticleType particle) {
        this.particle = particle;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<ParticleWeaponAttack> {
        private Loader() {
        }

        public ParticleWeaponAttack deserialize(JsonObject json) {
            ResourceLocation location = JsonHelper.getResourceLocation((JsonObject)json, (String)"particle");
            if (!ForgeRegistries.PARTICLE_TYPES.containsKey(location)) {
                throw new JsonSyntaxException("Unknown particle ID " + location);
            }
            ParticleType type = Objects.requireNonNull((ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(location));
            if (type instanceof SimpleParticleType) {
                SimpleParticleType simple = (SimpleParticleType)type;
                return new ParticleWeaponAttack(simple);
            }
            throw new JsonSyntaxException("Particle " + type + " be a simple particle, got " + type);
        }

        public ParticleWeaponAttack fromNetwork(FriendlyByteBuf buffer) {
            ParticleType type = (ParticleType)buffer.readRegistryIdUnsafe(ForgeRegistries.PARTICLE_TYPES);
            if (type instanceof SimpleParticleType) {
                SimpleParticleType simple = (SimpleParticleType)type;
                return new ParticleWeaponAttack(simple);
            }
            throw new DecoderException("Particle " + type + " be a simple particle, got " + type);
        }

        public void serialize(ParticleWeaponAttack object, JsonObject json) {
            json.addProperty("particle", Objects.requireNonNull(object.particle.getRegistryName()).toString());
        }

        public void toNetwork(ParticleWeaponAttack object, FriendlyByteBuf buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.PARTICLE_TYPES, (IForgeRegistryEntry)object.particle);
        }
    }
}

