/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSalvage
implements ICustomOutputRecipe<Container> {
    protected final ResourceLocation id;
    protected final Ingredient toolIngredient;
    protected final int maxToolSize;
    protected final ModifierId modifier;
    protected final int minLevel;
    protected final int maxLevel;
    @Nullable
    protected final SlotType.SlotCount slots;

    public ModifierSalvage(ResourceLocation id, Ingredient toolIngredient, int maxToolSize, ModifierId modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
        this.id = id;
        this.toolIngredient = toolIngredient;
        this.maxToolSize = maxToolSize;
        this.modifier = modifier;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.slots = slots;
        ModifierRecipeLookup.addSalvage(this);
    }

    public boolean matches(ItemStack stack, IToolStackView tool, int originalLevel) {
        return originalLevel >= this.minLevel && originalLevel <= this.maxLevel && this.toolIngredient.test(stack);
    }

    public void updateTool(IToolStackView tool) {
        if (this.slots != null) {
            tool.getPersistentData().addSlots(this.slots.getType(), this.slots.getCount());
        }
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.DATA.get();
    }

    @Deprecated
    public boolean m_5818_(Container inv, Level level) {
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getMaxToolSize() {
        return this.maxToolSize;
    }

    public ModifierId getModifier() {
        return this.modifier;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierSalvage> {
        public ModifierSalvage fromJson(ResourceLocation id, JsonObject json) {
            Ingredient toolIngredient = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"tools"));
            int maxToolSize = GsonHelper.m_13824_((JsonObject)json, (String)"max_tool_size", (int)16);
            ModifierId modifier = ModifierId.getFromJson(json, "modifier");
            int minLevel = JsonUtils.getIntMin(json, "min_level", 1);
            int maxLevel = GsonHelper.m_13824_((JsonObject)json, (String)"max_level", (int)Integer.MAX_VALUE);
            if (maxLevel < minLevel) {
                throw new JsonSyntaxException("Max level must be greater than or equal to min level");
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"slots"));
            }
            return new ModifierSalvage(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, slots);
        }

        @Nullable
        protected ModifierSalvage fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient toolIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int maxToolSize = buffer.m_130242_();
            ModifierId modifier = ModifierId.fromNetwork(buffer);
            int minLevel = buffer.m_130242_();
            int maxLevel = buffer.m_130242_();
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            return new ModifierSalvage(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, slots);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, ModifierSalvage recipe) {
            recipe.toolIngredient.m_43923_(buffer);
            buffer.m_130130_(recipe.getMaxToolSize());
            recipe.modifier.toNetwork(buffer);
            buffer.m_130130_(recipe.minLevel);
            buffer.m_130130_(recipe.maxLevel);
            SlotType.SlotCount.write(recipe.slots, buffer);
        }
    }
}

