/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class DamageableMeltingRecipe
extends MeltingRecipe {
    public DamageableMeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts) {
        super(id, group, input, output, temperature, time, byproducts);
    }

    private static FluidStack scaleOutput(FluidStack fluid, int damage, int maxDamage) {
        return new FluidStack(fluid, Math.max(fluid.getAmount() * (maxDamage - damage) / maxDamage, 1));
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        FluidStack output = this.getOutput();
        ItemStack input = inv.getStack();
        int maxDamage = input.m_41776_();
        if (maxDamage <= 0) {
            return output.copy();
        }
        return DamageableMeltingRecipe.scaleOutput(output, input.m_41773_(), maxDamage);
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, IFluidHandler handler) {
        ItemStack input = inv.getStack();
        int maxDamage = input.m_41776_();
        if (maxDamage <= 0) {
            super.handleByproducts(inv, handler);
        } else {
            int itemDamage = input.m_41773_();
            for (FluidStack fluidStack : this.byproducts) {
                handler.fill(DamageableMeltingRecipe.scaleOutput(fluidStack, itemDamage, maxDamage), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.damagableMeltingSerializer.get();
    }
}

