/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;

public abstract class AbstractCastingRecipe
implements ICastingRecipe {
    @Nonnull
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient cast;
    protected final boolean consumed;
    protected final boolean switchSlots;

    public abstract ItemStack m_8043_();

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.cast});
    }

    public AbstractCastingRecipe(@Nonnull RecipeType<?> type, ResourceLocation id, String group, Ingredient cast, boolean consumed, boolean switchSlots) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.id = id;
        this.group = group;
        this.cast = cast;
        this.consumed = consumed;
        this.switchSlots = switchSlots;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public Ingredient getCast() {
        return this.cast;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public boolean switchSlots() {
        return this.switchSlots;
    }

    public static abstract class Serializer<T extends AbstractCastingRecipe>
    extends LoggingRecipeSerializer<T> {
        protected abstract T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, boolean var4, boolean var5, JsonObject var6);

        protected abstract T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, boolean var4, boolean var5, FriendlyByteBuf var6);

        protected abstract void writeExtra(FriendlyByteBuf var1, T var2);

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient cast = Ingredient.f_43901_;
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            boolean consumed = false;
            boolean switchSlots = GsonHelper.m_13855_((JsonObject)json, (String)"switch_slots", (boolean)false);
            if (json.has("cast")) {
                cast = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"cast"));
                consumed = GsonHelper.m_13855_((JsonObject)json, (String)"cast_consumed", (boolean)false);
            }
            return this.create(recipeId, group, cast, consumed, switchSlots, json);
        }

        @Nullable
        protected T fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient cast = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            boolean consumed = buffer.readBoolean();
            boolean switchSlots = buffer.readBoolean();
            return this.create(recipeId, group, cast, consumed, switchSlots, buffer);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130070_(((AbstractCastingRecipe)recipe).group);
            ((AbstractCastingRecipe)recipe).cast.m_43923_(buffer);
            buffer.writeBoolean(((AbstractCastingRecipe)recipe).consumed);
            buffer.writeBoolean(((AbstractCastingRecipe)recipe).switchSlots);
            this.writeExtra(buffer, recipe);
        }
    }
}

